# ****************************************************************************
# Surgeweb javascript - Windowing / layout and display reformatting
# Note: sw.js is the primary surgeweb javascript code
# ----------------------------------------------------------------------------
#  - top level message display calls: show_msg + show_edit + supporting fns
#  - popup window handling
#  - tabbed display window manager
#  - layout & resizing & scollers
#  - menubar support
# ****************************************************************************
# Code that deals with editing of messages in popup/tab/inline configurations
function show_edit(jmsg,e,force)
{
#	If we can "just switch" lets do so
	if (sw.is_popup || (class_contains(sw.active,'message')&&(jmsg.action!='compose')) ){
		switch_msg_to_edit(sw.active,jmsg);
		var w=sw.is_popup?sw_win:window;
		w.jmsg_complete(jmsg);
		jmsg.cb=undefined;
		sw.jmsg=jmsg;
		if(jmsg.action=='redirect'){
			show_edit_step2_popup();
			return;
		}
		init_editor("eframe"+sw.active.instance, function(){
			show_edit_step2_popup();
		});
		return;
	}
#	// First try opening as a popup if we are supposed to / can
	if (try_popup_smart(pref.windows,e,force)){
		var opt={}
		if(jmsg.sim){ opt.width=600; opt.height=400;}

		var new_win = open_popup('cmd=show&page=popup_msg.htm&if=ajax'+(pref.devt_mode?'&pref_devt_mode=true':'')+'&language=||language||&static=||web_ref_path||',true,opt);
		if (new_win!=null) {
			pending_popups[new_win]={'type':'edit', 'jmsg':jmsg};
			return;
		}
		if (!confirm("Popup was blocked, temporarily use tabbed interface instead? \n\nPress cancel if you are going to allow popups."))
			return;
		pref.windows='tabbed';
		ajax_pref_save('pref_windows='+pref.windows);
		class_remove(document.getElementById('switcher'),'hidden');
		// "Execution" continues end of do_popup_init + show_xxx_complete_popup "additional step"
	}

#	// Just edit message in intab inline
	dbg('~inline.tpl - queue adding request')
#	queued_req_add( enFG, 'message_tpl', function(jmsg){
		dbg('~inline.tpl - actioning request')
||if_set(newlook_ui)||
		new_populate_edit('cmd=show&page=~inline.htm&if=ajax&static=||web_ref_path||&||vz||', function(node){
||else||
		sndReqCached('cmd=show&page=~inline.htm&if=ajax&static=||web_ref_path||&||vz||', function(chan){
			dbg('~inline.tpl - request completed')
			var node=actionReqSethtml(chan.responseText,'utility');
||endif||

#			setup references for switching and tracking
			node.popup_message=document.getElementById('message_panel');
			node.popup_compose=document.getElementById('compose_panel');
			node.popup_message.container=node;

			unique_instance(node,instance++);
			window_manager_newtab(node,'message');
			window_manager_altinit(node);

			switch_msg_to_edit(node.popup_message,jmsg);	//<< works for now

			sw.jmsg=jmsg;
			if(jmsg.action=='redirect'){
				show_edit_step2_inline(jmsg,node.instance);
				return;
			}
			init_editor("eframe"+node.instance, function(){
				show_edit_step2_inline(jmsg,node.instance);
			});

# TDOD(marijn) decide where to place permanently
			if(sw.altui){	// QQQWWW
#				class_remove(dge('utility_alt2').parentNode, 'hidden');
			}

		}, ch[enFG]);
#	},jmsg);
	touch(5);
}

# Code that deals with display of messages in popup/tab/inline configurations
function show_msg(mid,e,opt)
{
	if(!opt) opt={};
	if(pref.markread_onopen && !disable_markread_fld) mark_read(mid);

	if(sw.fld_type==enDraft||sw.fld_id=='$$Notes$$'){
		return do_edit(e);
	}
	var jmsg=sel_to_jmsg([mid],'view');
	if(msg_draft(mid)){
		return do_edit(e);
	}

	set_ads_targeted(jmsg.subject);

#	// First try opening as a popup if we are supposed to / can
	if (try_popup_smart(pref.windows,e,opt.force) || (sw.altui && opt.dbl_click)){
		var new_win = open_popup('cmd=show&page=popup_msg.htm&if=ajax&language=||language||&static=||web_ref_path||',true);
		if (new_win!=null) {
			pending_popups[new_win]={'type':'msg', 'jmsg':jmsg};
#			// "Execution" continues end of do_popup_init + show_xxx_complete_popup "additional step"
			return;
		}
		if (!confirm("Popup was blocked, temporarily use tabbed interface instead? \n\nPress cancel if you are going to allow popups."))
			return;
		class_remove(document.getElementById('switcher'),'hidden');
		pref.windows='tabbed';
		ajax_pref_save('pref_windows='+pref.windows);
	}

#	Standard altui does not have message display through double click
	if(sw.altui) return;

#	In inline mode make sure messages do not hang around
	if(pref.windows=='inline' && sw.msg_tab){
		window_manager_killpane(sw.msg_tab.sw_message.tab_ref.node_ref);
	}

#	Disply message inline in new tab (queued to not halt message retrieval)
	dbg('~inline.tpl - queue adding request')
	queued_req_add( enQ, 'message_tpl', function(mid){
		dbg('~inline.tpl - actioning request')
		sndReqCached('cmd=show&page=~inline.htm&if=ajax&static=||web_ref_path||&||vz||', function(chan){
			dbg('~inline.tpl - request completed')
			var node=actionReqSethtml(chan.responseText,'utility');
#			setup references for switching and tracking
			node.popup_message=document.getElementById('message_panel');
			node.popup_compose=document.getElementById('compose_panel');
			node.popup_message.container=node;
			gs_set_cursor_mid(sw.ml,mid);
			node.popup_message.mid=mid;
			unique_instance(node,instance++);
			class_remove(panel_correct(node.sw_message),'hidden');
			window_manager_newtab(node,'message');
			show_msg_step2_inline(jmsg,node.instance);

			if(!string_empty(asap_pending)){
				hide_loading();
				asap_pending=U;
			}
		},ch[enQ]);
	},mid);
	touch(6);
}

#qqqtab
function switch_msg_to_edit(node,jmsg)
{
	var outer=node.container;
	class_add(panel_correct(outer.popup_message),'hidden');
	class_remove(panel_correct(outer.popup_compose),'hidden');
	menubar_init('menu_compose');
	class_add(outer.popup_compose,jmsg_display_class(jmsg));
	sw.type='edit';
	set_sw_active(outer.popup_compose);
	if (!sw.is_popup){
		outer.popup_compose.tab_ref=outer.popup_message.tab_ref;
		set_tab_node_ref(outer.popup_compose.tab_ref,outer.popup_compose);
		outer.popup_compose.menu_ref=sw.menubar.menus["menu_compose"];
	}
||if(newlook_ui)||
	if(pref.hide_formatting && !sw.is_popup){
		do_formatting_toggle();
	}
||endif||
}


# ------------------

# Set the msg / edit pane defaults and wait for data (additional popup step??)
function show_xxx_complete_popup()
{
	var container=sw.active.container;
	if (sw.type=='msg'){
		class_remove(panel_correct(container.popup_message),'hidden');
		toolbar_buttons_customise2(sw_win.pref.toolbar_buttons);
		menubar_init('menu_message');
		show_msg_step2_popup();
	}else{
		class_remove(panel_correct(container.popup_compose),'hidden');
		set_sw_active(container.popup_compose);
		menubar_init('menu_compose');
		class_add(sw.active,jmsg_display_class(sw.jmsg));
#		panel_show_old("compose");
		if(sw.jmsg.action!='redirect')
			setTimeout('init_editor("eframe'+container.popup_compose.instance+'");',100);
		show_edit_step2_popup();
	}
}



# Wait till we have message for display
function show_msg_step2_popup()
{
	var jmsg=sw.jmsg;
	if (jmsg.cb && !jmsg.cb(jmsg)) {
		if(!jmsg.cb_requested){
			sw_win.retrieve_msg(jmsg.fld_id,jmsg.cache_mid);
			jmsg.cb_requested=true;
			dbg('Requested message from popup '+jmsg.cache_mid);
		}

		setTimeout(show_msg_step2_popup,200);
		dbg('message still loading, trying again shortly');
		return;
	}

	var xid=cache_id(jmsg.ident,jmsg.fid,jmsg.cache_mid);
#	make sure we set correct dom node, maybe make more generic?? or use assign_destination_html ()
	sw.active.childNodes[1].innerHTML = sw_win.html_from_cache(xid);
	sw.active.jmsg=jmsg;
	sw_win.pending_popups[window]=null;
	popup_resize();
	sw.active.focus();
	var qmsg=sw_win.cache_find(xid);
	check_rrcpt(qmsg);
}
function show_msg_step2_inline(jmsg,instance)
{
	var xid = cache_id(jmsg.ident,jmsg.fid,jmsg.cache_mid);
	var qmsg=cache_find(xid);
	if (!qmsg) {
		if(!jmsg.cb_requested){
			retrieve_msg(jmsg.fld_id,jmsg.cache_mid);
			jmsg.cb_requested=true;
			dbg('Requested message inline '+jmsg.cache_mid);
		}
		setTimeout(function(){show_msg_step2_inline(jmsg,instance)},200);
		dbg('message still loading, trying again shortly mid='+jmsg.cache_mid);
		return;
	}

	var el = dge('message'+instance+'_panel');
	var el2 = to_msg_display(el);
	var el3 = message_preview_real_el(el2);

	el3.innerHTML = html_from_qmsg(qmsg,'8 '+xid);

	sw.active.jmsg=jmsg;
	set_tab_text(qmsg.data['subject']);
	do_resize();
	check_rrcpt(qmsg);

	if(jmsg.havehist) return;
	var email="";
	if(qmsg.data['to'].length>0) email = split_address(qmsg.data['from'][0])[1];
	var node = dge('message'+instance+'_panel');
	history_extra(email,node,'view',jmsg.cache_mid);
	
}



# Wait till we have message "to reply with" then fill out the "in place" compose pane
function show_edit_step2_popup()
{
	var jmsg=sw.jmsg;
	if (jmsg.cb && !jmsg.cb(jmsg)) {
		if(!jmsg.cb_requested){
			sw_win.retrieve_msg(jmsg.fld_id,jmsg.cache_mid);
			jmsg.cb_requested=true;
			dbg('Requested message from popup '+jmsg.cache_mid);
		}
		dbg('message still loading, trying again shortly');
		setTimeout(show_edit_step2_popup,20);
		return;
	}else if(jmsg.to==undefined){
#		// Message has not even been requested!! probably just selection boxes ticked
		alert('is this code still getting run??')
		jmsg.cb=sw_win.jmsg_check_ready;
		sw_win.retrieve_msg(jmsg.fld_id,jmsg.cache_mid);
		setTimeout(show_edit_step2_popup,20);
		return;
	}

	dbg('show message for edit POPUP [M'+jmsg.instance+']');

	show_edit_complete(jmsg,sw.active);
	popup_resize();
}
function show_edit_step2_inline(jmsg,instance)
{
	// Find our input data
	if(jmsg)
		jmsg.instance=instance;
	else
		jmsg=sw.jmsg;

	if(jmsg.to==undefined){
		if (jmsg.cb && !jmsg.cb(jmsg)) {
			if(!jmsg.cb_requested){
				retrieve_msg(jmsg.fld_id,jmsg.cache_mid);
				jmsg.cb_requested=true;
				dbg('Requested message inline '+jmsg.cache_mid);
			}
			dbg('message still loading, trying again shortly');
			setTimeout(function(){show_edit_step2_inline()},20);
			return;
		}else if(jmsg.to==undefined){
#			// Message has not even been requested!! probably just selection boxes ticked
#			jmsg.cb=jmsg_check_ready;
#			retrieve_msg(jmsg.fld_id,jmsg.cache_mid);
#			setTimeout(show_edit_step2_inline,20);
#			return;
			alert("unknown condition 2")
		}
	}

	dbg('show message for edit INLINE [M'+jmsg.instance+']');

	show_edit_complete(jmsg,dge('compose'+jmsg.instance+'_panel'));

	do_resize_real();
}

function show_edit_complete(jmsg,node)
{
	var sig_id,realsig,autosubject;
	node.jmsg=jmsg;

	if(false) {
		el=node.field_from.parentNode;
		remove_node(node.field_from);
		el.innerHTML=identities_html();
		node.field_from=el.firstChild;
	} else {
		set_from(node.field_from,work_out_from(jmsg));	//QQSIG
	}

	if(!pref.hide_surgevault) {
		class_remove(node.field_encrypt.parentNode,'hidden');
		class_remove(dge('send_encrypt'), 'hidden');
	}else{
		class_add(dge('send_encrypt'), 'hidden');
	}
	if(pref.vault_ifnew)
		class_remove(node.field_ifnew.parentNode,'hidden');

	node.field_confirm.value=jmsg.confirm;
	node.field_encrypt.value=(jmsg.encrypt=='surgevault'?jmsg.encrypt:'');	// QQENC
	node.field_priority.value=jmsg.priority;
	fancy_edit_set(node.field_to,jmsg.to);
	fancy_edit_set(node.field_cc,jmsg.cc,jmsg.action=='reply_all');
	fancy_edit_set(node.field_bcc,jmsg.bcc);
	vcheck_run();

	sig_id=preferred_sigid();

	var enc_el=sw.active.field_encrypt;
	var enc_val=(pref.vault_lock?'surgevault':'');
	var override = (jmsg.action=='reply_all' && pref.compose_sticky && jmsg.cc.length>0);
	if(pref.compose_sticky){
		sw.active.field_sticky.checked=true;
		if(pref.compose_sticky[0] && !override) show_cc(undefined,undefined,true);
		if(pref.compose_sticky[1]) show_cc('bcc',undefined,true);
		if(pref.compose_sticky[2]) show_cc('extra',undefined,true);
		if(pref.compose_sticky[3]) sw.active.field_priority.value=pref.compose_sticky[3];
		if(pref.compose_sticky[4]) sw.active.field_confirm.value=pref.compose_sticky[4];
		if(pref.compose_sticky[5]&&!pref.vault_lock) enc_val=pref.compose_sticky[5];
		if(pref.compose_sticky.length>6) sig_id=pref.compose_sticky[6];
		if(pref.compose_sticky.length>7) autosubject=pref.compose_sticky[7];
		if(pref.compose_sticky.length>8) sw.active.field_ifnew.value=pref.compose_sticky[8];
	}
	if(jmsg.sig_id) sig_id = jmsg.sig_id;
	if(pref.surgevault_reply&&jmsg.encryption=='svault'&&!pref.vault_lock) enc_val='surgevault';
	if(!pref.hide_surgevault){
		encrypt_set(dge('send_encrypt'),enc_el,enc_val);
	}

#	if(pref.sim_enable){
#		class_remove(dge('send_sim'),'hidden');
#	}
	if(pref.sim_enable && (jmsg.autosubject || (jmsg.sim/*jmsg.action=='compose' && autosubject=='true'*/))){
		node.field_subject.value="";
		sim_init(false,false);
		class_add(node.editor_bar, 'hidden');
		sig_id="";
	}else{
		node.field_subject.value=jmsg.subject;
	}
	populate_signature_early(sw.active.field_signature);
	sw.active.field_signature.value=sig_id;
	if(sig_id.length>0&&sig_id!='none'&&sw.signatures[sig_id]){
		realsig=sw.signatures[sig_id].body;	//QQSIG
		if(realsig.indexOf('<')!=-1){
			jmsg.send_mode='html';
		}
	}else{
		realsig='';
	}


	if(jmsg.cc.length>0) show_cc('cc',node,override);
	if(jmsg.bcc.length>0) show_cc('bcc',node);

#	if(!jmsg.attach_ids) jmsg.attach_ids=[];
#	Client side allocated attachment message ids, very slightly unsafe as it may trample on the same session
#	if surgemail is restarted, but use of flash cannot use server returned message_id
	if(!jmsg.attach_mid) jmsg.attach_mid = 'c_' + sid + '_' + jmsg.instance;		// popup used to have instance??

	node.field_send_mode.innerHTML=(jmsg.send_mode=='html'?'$$st_opt_sendmode_html$$':'$$st_opt_sendmode_text$$');

	if(pref.cloudfile_enabled){
		class_remove(node.html5_select2, 'hidden');
		class_remove(node.attach_cloud, 'hidden');
	}

#	Do any additional init depending on send action type
	attachments_setup(node,jmsg);

	if(!sw.is_popup)
		set_tab_text(jmsg.subject.length>0?jmsg.subject:(jmsg.note?'$$st_new_note$$':'$$st_new_message$$'));

	if(pref.editor_textonly){
		var extra='';
		if(realsig.length>0 || jmsg.msg_text.length>0){
			extra+='\n\n';
			extra+=realsig;
			if(realsig.length>0) extra+='\n\n';
		}
		if(jmsg.not_new) extra='';

		var ta=node.field_xeframe.firstChild;
		ta.value = extra+jmsg.msg_text;

	}else{

		var extra
		if(false){
			extra=(isIE?'':'<br _moz_editor_bogus_node="TRUE" _moz_dirty=""/>');
			if(realsig.length>0 || jmsg.msg_html.length>0){
				extra+='<br><br>';
				extra+='<div id="editor_signature">'+realsig+'</div>';
				if(realsig.length>0) extra+='<br><br>';
			}
		}else{
||if_set(newlook_ui)||
			extra='<div></div>';
||else||
			extra='<div>&nbsp;</div>';
||endif||
			if(realsig.length>0 || jmsg.msg_html.length>0){
				extra+='<div>&nbsp;</div>';
				extra+='<div id="editor_signature">'+realsig+'</div>';
				if(realsig.length>0) extra+='<div>&nbsp;</div>';
			}
		}
		if(jmsg.not_new) extra='';


		var rt=node.field_eframe;
		xdoc=rt.contentWindow.document;

		xdoc.open();
		xdoc.write('<html><head>');
		xdoc.write('<style>');
		xdoc.write(' .sw_message P{margin:0px;padding:0px;}');
		xdoc.write(' .sw_message {FONT-SIZE: '+default_font_size()+'pt;FONT-FAMILY:Arial,Helvetica,sans-serif;background:white;}');
		xdoc.write(' span.mark {background:url(||www_base||shared/img/squiggle.gif?||vz||) bottom repeat-x;}');
||ifdef||_note_not_yet_||
		if(!pref.notes_oldformat){
			xdoc.write(' .note_itself, .note_itself .sw_message {background:#efe9b7;}');
			xdoc.write(' .note_itself, .note_itself .sw_message {font-family:Monaco,"Lucida Console","Courier New",monospace;}');
		}
||endif||
		if(!pref.no_replycolor) xdoc.write(quote_styles());
		xdoc.write('</style>');

||ifdef||_note_not_yet_||
		xdoc.write('<body class="sw_message'+(jmsg.note?' note_itself':'')+'">'+extra+jmsg.msg_html+'</body></html>')
||else||
		xdoc.write('<body class="sw_message">'+extra+jmsg.msg_html+'</body></html>')
||endif||
		xdoc.close();
		
#		rt.contentWindow.onload = function(){
#			debugger
#			var el=rt.contentWindow;
#			el.focus();
#			editor_do('fontName','comic sans ms,san-serif');
#		}
		
		sw.xwin_for_spelcheck = rt.contentWindow;
		setTimeout(function(){
#		rt.contentWindow.onload = function(){
#		rt.contentWindow.onreadystatechange = function(){

#			var el=rt.contentWindow;
#			el.focus();
#			editor_do('fontName','comic sans ms,san-serif');

#			setTimeout(function(){

			if(!jmsg.not_new && realsig.length>0){
				signature_select(U,realsig,rt.contentWindow);
				populate_signature_late();
			}

			if(sw.is_popup)
				window.focus();		// Used to only for popup??


			if (fancy_edit_value(node.field_to).length==0)
				node.field_to.focus();
			else{
				var el=node.field_eframe.contentWindow;
				el.focus();
				el.document.body.focus();
			}
			add_event(node.field_eframe.contentWindow.document,"keyup", editor_keyup);
			add_event(node.field_eframe.contentWindow.document,"keydown", editor_keydown);
			add_event(node.field_eframe.contentWindow.document,"keypress", editor_keypress);
			add_event(node.field_eframe.contentWindow.document,"paste", editor_paste);
#			},2000);
		},200);
#		}
	}

	x_ac_pageload();
	if(!sw.is_popup) subject_init();

	// if(isIOS){
	// 	class_add(dge("btn_attach"),'hidden');
	// }

	compose_type_update(node,jmsg);	 // QQQ NOTE
	if(do_fdnd() && !node.attachments_init){
		fdnd_init(node.compose_header,'all',fdnd_msg_hover,fdnd_msg_drop);
		if(!pref.hide_fdnd_info && !isIOS)
			class_remove(node.aq_container.previousSibling,'hidden');
	}

	var email="";
	if(jmsg.to.length>0) email = split_address(jmsg.to[0])[1];
	history_extra(email, node,'edit',jmsg.cache_mid);
}

function preferred_sigid()
{
	var sig_id = pref.cur_signature;
	var sig = sw.signatures[sig_id];
	if(sig==U) return '';
	if(pref.editor_textonly && sig.type!='text'){
		for(j=0;j<sigs();j++){
			var i = sw.sig_order[j];
			var sig2 = sw.signatures[i];
			if(sig2.type=='text'){
				sig=sig2;
				sig_id = i;
				break;
			}
		}
	}
	return sig_id;
}


function attachments_setup(node,jmsg)
{
	var get_attach;
	if (jmsg.attach_info && jmsg.attach_info.length>0){
		aq_init(node);
		var tmp=jmsg.attach_info;
		jmsg.attach_ids=undefined;
		jmsg.attach_info=undefined;
		setTimeout(function(){aq_attachments_set(node,tmp);},25);
		return;
	}

	if(jmsg.action=='forward_attach'){
		get_attach=true;
	} else if(jmsg.action=='forward' || jmsg.action=='edit' || jmsg.action=='resend' || jmsg.action=='send_asnew'){
		if(jmsg.nattach>0 || jmsg.related)	get_attach=true;
	} else if(jmsg.action=='redirect'){
		custom_edit_disable(node.field_subject);			// Popup used to have : node.field_subject.disabled=true;
		node.field_eframe.disabled=true;
		if(jmsg.nattach>0)	get_attach=true;
	} else if(jmsg.action=='compose' && jmsg.vcard_abk){
		get_attach=true;
	}

	if(get_attach){
		aq_init(node);
		var w=sw.is_popup?sw_win:window;
#		// Fire off request to get orig message(s) as an attachment
#		dbg("*********** process attach new")
		w.ajax_attach_get(node.jmsg,function(att,att_mpr){
			aq_attachments_set(node,att,att_mpr);
			fdnd_init(node.compose_header,'all',fdnd_msg_hover,fdnd_msg_drop);
		});
	}
}


var tabindex_base=5;
function unique_instance(node,id)
{
	node.instance=id;
	node.id='message'+id+'_container';
	var o1=document.getElementById('message'+'_panel');;
	o1.instance=id;
	o1.id='message'+id+'_panel';

	var o=document.getElementById('compose'+'_panel');;
	o.instance=id;
	o.id='compose'+id+'_panel';

	o.field_to=customise_edit(set_instance('edit_to',id),'fancy');
	o.field_to.tabIndex = tabindex_base++;
	o.field_cc=customise_edit(set_instance('edit_cc',id),'fancy');
	o.field_cc.tabIndex = tabindex_base++;
	o.field_bcc=customise_edit(set_instance('edit_bcc',id),'fancy');
	o.field_bcc.tabIndex = tabindex_base++;
	o.field_subject=customise_edit(set_instance('edit_subject',id),'plain');
	o.field_subject.tabIndex = tabindex_base++;
	o.field_priority=set_instance('edit_priority',id);
	o.field_signature=set_instance('edit_signature',id);
	o.field_encrypt=set_instance('edit_encrypt',id);
	o.field_ifnew=set_instance('edit_ifnew',id);
	o.field_confirm=set_instance('edit_confirm',id);
	o.field_sticky=set_instance('edit_sticky',id);
	o.redirect_hide=set_instance('redirect_hide',id);
||ifdef||_note_not_yet_||
	o.field_keeptime=set_instance('note_keeptime',id);
||endif||
	o.html5_select=set_instance('html5_select',id);
	o.html5_select2=set_instance('html5_select2',id);
	o.attach_cloud=set_instance('attach_cloud',id);

	o.field_from=set_instance('edit_from',id);
	o.field_send_mode=set_instance('send_mode',id);
	o.field_switch=set_instance('editor_switch_button',id);
	class_remove(set_instance('editor_spellcheck_button',id),'hidden');
	o.view_extra=set_instance('view_extra',id);
	o1.view_extra=o.view_extra;
	o.compose_header=set_instance('compose_header',id);
	o.compose_extra=set_instance('compose_extra',id);
	o1.compose_extra=o.compose_extra;
	o.aq_container=set_instance('aq_container',id);
	o.aq_files=set_instance('aq_files',id);
	o.attach_status=set_instance('divStatus',id);
	o.button_place_holder=set_instance('spanButtonPlaceHolder',id);
	o.editor_bar=set_instance('editor_bar',id);

	o.field_eframe=set_instance('eframe',id);
	o.field_eframe.tabIndex = tabindex_base++;
	o.field_xeframe=set_instance('xeframe',id);

	var x=set_instance('etbar',id);
	x.eframe=o.field_eframe;

	x.field_switch=o.field_switch;
	o.field_xeframe.tbar = x;

	sw.msg_tab=node;
}





# ******************

function window_manager_init()
{
	var node = sw.msgs_pane;
	window_manager_newtab(sw.msgs_pane,'main');
	node.menu_ref=sw.menubar.menus["menu_bar_main"];

	// Select the default list page layout (posibly default to landing alternatively)
	layout_fldmsg(enFLD);
}
function window_manager_lateinit()
{
	if(sw.altui){	// QQQWWW
		class_add(dge('switcher'), 'hidden');
	}
}

function window_manager_minimise(el,restore_main)
{
	if (!el) return false;

	if(sw.altui){
#		has a whole different windowing model
#		panel_hide(el);				// << HIDES the old messages when adding new msg
#		if (!class_contains(el,"fldmsg") ){
#			class_add(dge('alt_slideup'),'hidden');
#		}
		altui_hide_utility();
		if (restore_main){
			window_manager_restore();
		}
		return;
	}

	if (class_contains(el,"fldmsg") ){
		layout_fldmsg(0);
		class_remove(panel_correct(el.tab_ref),'selected');
		return;
	}

	dbg('window_manager_minimise el.className='+el.className+" el.id"+el.id);
	// check prerequisites, such as too manyentries minimised

#	Just destroy any panes that cannot be minimised
	if (!el.tab_ref){
		el=panel_correct(el);
		el.parentNode.removeChild(el);
		set_sw_active(U);
		return;
	}

	var tab=el.tab_ref;
	if(!sw.altui){
		panel_hide(el);
	}

	set_sw_active(U);

#	Now restore the default folder list / message display pane if required
#	I think this is redundant now...
	if (restore_main)
		window_manager_restore();
}

# Create a new tab and associate it with a DOM node
function window_manager_newtab(node,type)
{
	dbg('window_manager_newtab');
	var tab;
	tab=new_anchor3("amsg","switcher");
	if(type=='main'){
		tab.innerHTML='$$st_mailbox$$ (<font id="foldername_tab">$$INBOX$$</font>)';
		tab.id = "tab_main";
	}else{
		window_uid++;
		tab.id = "tab"+window_uid;
		tab.innerHTML='<img src="||www_base||shared/img/1pixel.gif" class="closetab" onclick="tab_close(\''+tab.id+'\')"><span class="tab_text"></span>'; //message'+window_uid+'
	}
	tab.tab_id=tab.id;
	tab.tab_type=type;
	panelise_roundtop(tab,enHdr);
	var o=panel_correct(tab);
	o.firstChild.style.marginTop=0;
	class_add(o,'tab_outer');
	class_add(o,'selected');
	tab.txtnode=tab.firstChild.nextSibling;
	tab.txtnode.style.width=px(120-22-4);
	tab.onclick=function(e){
		dbg("tab click id ");
		app_menu_mail();
		if (!tab.node_ref) { dbg("tab does not have display node associated with it"); return;}
		if (!sw.active) { alert("sw.active is null !!"); return;}
		if (tab.closing) return;
		var el=sw.active;
		if(el.tab_id==tab.tab_id) return;

		window_manager_minimise(el,false);
		restoreMsgFromTab(tab);
	}
	if (type=='main'){
		set_tab_node_ref(tab,sw.msgs_pane);
	}else if (type=='message'){
		set_tab_node_ref(tab,node.sw_message);
	}else{
		node=panel_correct(node,'inner');
		set_tab_node_ref(tab,node);
	}
	tab.node_ref.tab_id=tab.tab_id;
	tab.node_ref.tab_ref=tab;

	if(sw.altui){	// QQQWWW
#		class_remove(dge('utility_alt2').parentNode, 'hidden');
#		windows_manager_tabsformat();
	}

	return tab;
}

function windows_manager_tabsformat()
{
	var el = dge('switcher');
#	if(el.childNodes.length<2) {
#		el.style.backgroundColor = 'pink';
#	}else{
		el.style.backgroundColor = 'lightgray';
#	}
	if(el.childNodes.length>0) {
		class_remove(dge('switcher'), 'hidden');
	}else{
		class_add(dge('switcher'), 'hidden');
	}
}

# Given tab, safely restore its contents to the utility pane
function restoreMsgFromTab(tab)
{
	var util=sw.util;

#	Any per tab type behaviour??
	if (tab.tab_type=='main'){
#		Need to know what is displayed in main tab and show it
	}else if (tab.tab_type=='message'){
#		Need to know what is displayed in message tab and show it
	}else{
#		just restore from DOM node panel reference
	}
	panel_show(tab.node_ref);
	set_sw_active(tab.node_ref);
	if(sw.active.menu_ref && sw.active.menu_ref.id=='menu_compose'){
		var enc=sw.active.field_encrypt;
		encrypt_set(dge('send_encrypt'),enc,enc.value,enc.rcpt_count);
	}

	var jmsg=sw.active.jmsg;
	if(jmsg){
		dbg('Msg restored from tab [M'+jmsg.instance+']')
		compose_type_update(sw.active,jmsg);
# TDOD(marijn) decide where to place permanently
		if(sw.altui){	// QQQWWW
#			class_remove(dge('utility_alt2').parentNode, 'hidden');
		}
	}
	do_resize();
}
function set_tab_text(txt)
{
	sw.active.tab_ref.txtnode.innerHTML=encode_lt_gt(xencode(txt));
	sw.active.tab_ref.txtnode.title=txt; //decode_lt_gt(txt);
}



# Restore whatever we need to (may be fldmsg pane or the previous message we were editing)
function window_manager_restore()
{
	if(sw.cur_app_menu.id=='app_mail'){
		fldmsg_display();
	}else{
		eventFire(dge(sw.cur_app_menu.id),'click');
	}
}

function window_manager_killpane(node)
{
	if (sw.active==node){
		set_sw_active(U);
	}
	
	if(sw.altui && sw.alt_utility){
		altui_hide_utility();
		return;
	}
	
	
	var tab=node.tab_ref;
	node=panel_correct(node);
	if(!node.parentNode) return;

	if(sw.altui) {
		remove_node(node.parentNode.parentNode.parentNode);
	}else{
		remove_node(node);
	}

	if (tab){
		var o=panel_correct(tab);
		remove_node(o);
	}

	if(sw.altui){	// QQQWWW
		do_resize();

#		var el = dge('alt_overlay_pane');
#		class_add(el,'hidden');
#		windows_manager_tabsformat();
	}
}



function panel_hide(node)
{
	class_add(panel_correct(node),'hidden');
	if (node.menu_ref)
		menu_set('');
	if (node.tab_ref)
		class_remove(panel_correct(node.tab_ref),'selected');
}

function panel_show(node)
{
	class_remove(panel_correct(node),'hidden');
	if (node.menu_ref)
		menu_set(node.menu_ref.id);
	if (node.tab_ref)
		class_add(panel_correct(node.tab_ref),'selected');
}

function panel_remove(node)
{
	if (node.menu_ref)
		menu_set('');
	node=panel_correct(node);
	node.parentNode.removeChild(node);
}



# - Actual popup related stuff

var pending_popups=[];

function try_popup_smart(pref,e,force)
{
	var popup=false;
	if (force=='popup') return true;
	if (force=='inline') return false;
	if (!e) return pref=='popup';
||if_set(newlook_ui)||
	if (sw.global_late_shift) popup=true;
||endif||
	if (pref=='popup' || (e.shiftKey&&!e.ctrlKey)) popup=true;
	if (pref=='popup' && e.altKey) popup=false;
	return popup;
}

# - Layout & resizing stuff

#var sizer_reposition;	// Attempted to fix pane_ratio problems with this. (can't make it work)

var sizers_reg;
function sizers_reposition(xx)	//cf fix_sizers  do_layout
{
# 	var msgs=document.getElementById('messages');
# 	x.style.top=msgs.offsetTop + msgs.offsetHeight+'px';

	var sz1=xx['sz1'];
	var sz2=xx['sz2'];
	var sz3=xx['sz3'];
	if(!sizers_reg){
		Drag.init(sz1, sz1, ||folder_column_minwidth||,500,null,null, U,U, U,function(){return banner_height});
		Drag.cb(sz1,function(){sizer_active('sizer1')},U,sizer1_resize);

		Drag.init(sz2, sz2, 1,1000,null,null, U,U,sizer2_restrictx, sizer2_restricty);
		Drag.cb(sz2,function(){sizer_active('sizer2')},U,sizer2_resize);

		if(pref.todo){
			Drag.init(sz3, sz3, 700,2000,null,null, U,U,U, function(){return banner_height});
			Drag.cb(sz3,function(){sizer_active('sizer3')},U,sizer3_resize);
			class_remove(sz3,'hidden');
		}
		sizers_reg=true;
	}

	sz1.style.top=px(banner_height+1);
 	sz1.style.left=px(pref.sizer1-panel_gap-3);
	sz1.style.width=px(7);
 	sz1.style.height=px(ClientHeight()-banner_height-4);

	if(pref.preview=='horiz'){
		sz2.style.top=px(xx['cc_top']-1);
		sz2.style.left=px(pref.sizer1+pref.sizer2w-2);
		sz2.style.width=px(6);
		sz2.style.height=px(xx['cc_h']-xx['mnu_h']+footer);
		sz2.style.cursor='w-resize';
	}else{
		sz2.style.top=px(pref.sizer2>0?pref.sizer2:ClientHeight()*0.6);
		sz2.style.left=px(pref.sizer1);
		sz2.style.width=px(ClientWidth()-pref.sizer1-(showing_column3?pref.sizer3+panel_gap*2:0));
		sz2.style.height=px(7);
		sz2.style.cursor='s-resize';
	}

	sz3.style.top=px(banner_height+1);
	sz3.style.left=px(ClientWidth()-pref.sizer3-panel_gap*2-3);
	sz3.style.width=px(6);
	sz3.style.height=px(ClientHeight()-banner_height-4);
}
function sizer2_restrictx(val)
{
	if(pref.preview!='vert') return U;
	return pref.sizer1;
}
function sizer2_restricty(val)
{
	if(pref.preview!='horiz') return U;
	return xx['cc_top'];
}
function sizer_active(type)
{
	dbg(type+'_active');
	var x=document.getElementById(type);
	class_add(x,'sizer_active');
}
function sizer1_resize(x,y)
{
	dbg('sizer1_resize');
	var el=document.getElementById('sizer1');
	class_remove(el,'sizer_active');
	pref.sizer1=x+5;
	do_resize();
	ajax_pref_save("pref_sizer1="+pref.sizer1);
	clear_folder_menu('folder_menu');
}
function sizer2_resize(x,y)
{
	dbg('sizer2_resize');
	var el=document.getElementById('sizer2');
	class_remove(el,'sizer_active');
	if(pref.preview=='horiz'){
		pref.sizer2w=x-pref.sizer1;
		if (pref.sizer2w<150) pref.sizer2w=150;
		ajax_pref_save("pref_sizer2w="+pref.sizer2w);
	}else{
		var min=banner_height+xx['mnu_h'];
		if (y-min<40) y=40+min;
		pref.sizer2=y;
		ajax_pref_save("pref_sizer2="+pref.sizer2);
	}
	do_resize();
}
function sizer3_resize(x,y)
{
	dbg('sizer3_resize');
	var el=document.getElementById('sizer3');
	class_remove(el,'sizer_active');
	pref.sizer3=ClientWidth()-x+5;
	do_resize();
	ajax_pref_save("pref_sizer3="+pref.sizer3);
	clear_folder_menu('folder_menu');
}

function footer_update(xx)
{
	if(pref.footer_shrink<=0 || pref.footer_shrink>1100) return;
	var hide_footer = xx['screen_h']<pref.footer_shrink;
||if_set(always_hide_footer)||
	hide_footer = true;
||endif||
	var el = xx['footer'];
	class_update(el, 'hidden', hide_footer);
	footer=el.offsetHeight;
}


// Resizing tweaks dependant on exact panelisation... values may be further modified from extension code
var tweaks = {'cch' : {'none':1,'plain':-2,'orig':-2},
			  'lch' : {'none':1,'plain':-1,'orig':-1}};

# Primary layout resizing

function gen_resize()
{
	if(sw.is_popup){
		popup_resize();
	}else{
		do_resize_real();
	}
}
var resize_timer;
function do_resize()
{
	if(hack_nosize) return;
#	dbg('>> do_resize');
	if (!resize_timer) resize_timer=setTimeout(do_resize_real,40);
#	do_resize_real();
}
var xx=[];
function do_resize_real()
{
	resize_timer=undefined;

	if(sw.altui) {
#		// Resize the actual altui
		sw.altui.resize();
		
#		// Resize the content of the active pane
		if(sw.active.resize) sw.active.resize(ClientHeight()-44,ClientWidth()-200);
		
		fancy_scroll_update();
		return;
	}

#	dbg('>> do_resize_real');
#	document.getElementById('left_column').style.width=(100)+"px";
#	var all_width=pos_window_width(); << this function slightly dodgy when it comes to scrollbars
#	var centre_column=all_width-pref.sizer1-20;

	xx['pg']=dge('page_width')
	xx['ban']=dge('top_banner'); xx['ban_h']=xx['ban'].offsetHeight;
	xx['cl']=dge('left_column');
	xx['stat']=dge('status_container');
	xx['cc']=dge('center_column');
	xx['ccc']=dge('all_columns');
	xx['sz1']=dge('sizer1');
	xx['sz2']=dge('sizer2');
	xx['sz3']=dge('sizer3');
	xx['footer']=dge('sw_footer');

	xx['mnu_h']=panel_correct(dge('menubar')).offsetHeight+panel_gap;	// The padding is separate
	xx['cc_top']=xx['mnu_h']+xx['ban_h'];

	xx['screen_hh']=ClientHeight();
	if (xx['screen_hh']<420){
		xx['screen_h']=420;
	}else{
		xx['screen_h']=xx['screen_hh'];
	}
	xx['screen_ww']=ClientWidth();

	footer_update(xx);

#	This line MUST be done early
	resize_right_column(xx);

	xx['cc_ww']=xx['screen_ww']-pref.sizer1-right_column-panel_gap;
	xx['cc_w']=xx['screen_ww']>780+right_column ? xx['cc_ww'] : (780-pref.sizer1);

# TODO(marijn) check screen resizing magic delta
 	xx['cc_h']=xx['screen_h'] - (xx['ban_h'] + footer + panel_gap) + tweaks.cch[panel_mode]+3;

#	dbg('do_Resize_real: screen_h='+xx['screen_h']+'cc_h='+xx['cc_h']+'cc_w='+xx['cc_w']);

	// Now start doing stuff with measurements
	xx['cl'].style.width=px(pref.sizer1);

#	This actually sets the width of Central utility pane (else it would be full screen width)
	xx['cc'].style.width=px(xx['cc_w']);
	xx['ccc'].style.width=px(xx['cc_w']+pref.sizer1+right_column+panel_gap)

	xx['pg'].style.width=px( xx['screen_ww']>780 ? xx['screen_ww'] : 780);


	fix_scroll_bars(xx)

	resize_left_column(xx);
	resize_center_column(xx);
	sizers_reposition(xx);

	var el=document.getElementById('messages_list');
	var h=el.offsetHeight;
#	dbg("h resize="+h);
	list_h=h;

	if (!sw.active) {
		return;
	}

#	// Resize stuff in the main body panel appropriately
	htype=pref.mode=='web'?'minHeight':'height';
	if(class_contains(sw.active,'fldmsg')) {
		el=dge('search_input');
		xx['srch_w']=150+(xx['screen_ww']<800?0:(xx['screen_ww']-800)*0.5)
		el.style.width=px(xx['srch_w']-54);
		el.parentNode.style.width=px(xx['srch_w']);
		// everything already done
	}else if (sw.active.id=='iframe_panel'){
		el=dge('an_iframe');
		var ih=xx['cc_h']-4;
		var el2=dge('iframe_menu');
		if(el2) ih-=28;//el2.style.height;
		el.style[htype]=px(ih);
	}else if (sw.active.id=='chat_panel'){
		resize_chat(xx);
	}else{
		var o=sw.active;
		if (class_contains(o,'compose')){
			xx['chdr_h']=o.compose_header.offsetHeight;
			var ef = o.field_xeframe.firstChild;
			if(pref.editor_textonly){
				ef.style[htype]=px(xx['cc_h']-(xx['mnu_h']+xx['chdr_h']) - panel_gap - 4 - 24);
				ef.style['width']=px(xx['cc_w'] - panel_gap - 4 - 24);
			}else{
				ef.style[htype]=px(xx['cc_h']-(xx['mnu_h']+xx['chdr_h']) - panel_gap - 4);
			}
		}else{
			o.style[htype]=px(xx['cc_h']-xx['mnu_h']-2);
		}

		if(sw.active.resize) sw.active.resize(xx['cc_h']-xx['mnu_h']-2,xx['cc_w']);
	}

	if (pref.mode=='app') {
		xx['stat'].style.left=px(pref.sizer1);
		scroll_topleft(window);
	}
	if('true'=='||online_status_dev||'){
		chat_reposition()
	}
	fancy_scroll_update();
}
var extend_resize_timer;
function resize_left_column(xx)
{
	var x_lp=document.getElementById('lpanel_body')
	var x_le=document.getElementById('left_column_end')
	if (true /*pref.mode=='app'*/){
		x_lp.style.height=px((xx['screen_h']-(x_le.offsetTop+xx['ban_h'])-panel_gap)+x_lp.offsetHeight + tweaks.cch[panel_mode]);
	}else{
		x_lp.style.height="";
		x_lp.style.overflowY="";
	}

#	Call any extensions that need to resize themselves -
#	making sure they only get called once for consecutive resizes!!
	if(window.js_extend_resize){
		if(extend_resize_timer){
			clearTimeout(extend_resize_timer);
			extend_resize_timer=null;
		}
		extend_resize_timer=setTimeout(function(){ js_extend_resize(lc_width())}, 100);
	}

}

function resize_center_column(xx)
{
	var x_mnu=panel_correct(dge('menubar'))
	var x_list=dge('msglist_box')
	var x_msg=dge('message_preview')

	if (pref.mode=='web') {
		h=xx['cc_h']-(xx['mnu_h']+2);;
		x_list.style.minHeight=px(h);
		return;
	}
	if (preview=='v'){
#		if (sizer_reposition){
#			sizer_reposition=false;
#		}else{
#			This just seems to generally make a mess ofthe resizing
#			so lets not have ratio based horizontal divider
#			xx['sz2'].style.top=px(xx['ban'].offsetHeight+xx['mnu_h']+(x_list.offsetHeight+x_msg.offsetHeight)*pane_ratio);
#		}

		h=(xx['sz2'].offsetTop)-(xx['ban_h']+xx['mnu_h']) + 2;
		h2=xx['cc_h']-(xx['mnu_h']+h+2);

		x_list.style.height=px(h);
		x_msg.style.height=px(h2);
		x_list.style.width="";
		x_msg.style.width="";
		last_cc_h=xx['cc_h'];
	} else if (preview=='h'){
		class_add(x_msg,'widescreen_msg');
		h=xx['cc_h']-(xx['mnu_h']+2);
		ww=xx['cc'].offsetWidth-panel_gap-2;
		w1=pref.sizer2w;
		w2=ww-w1;
		if(showing_column3) w2=w2-pref.sizer3;
		x_list.style.height=px(h);
		x_msg.style.height=px(h);	// Remove for top & bottom border
		x_list.style.width=px(w1);
		x_msg.style.width=px(w2-2);
#		x_msg.style.left=px(xx['cl'].offsetWidth+w1+4); /// MAYBE NEED
		x_msg.style.top=xx['ban'].offsetHeight+xx['mnu_h'];	// Use outer top border
	} else {
		h=xx['cc_h']-(xx['mnu_h']+2);
		x_list.style.height=px(h);
	}
	// hack just for IE
#	dbg('**IE Hack... isIE='+isIE);
	if (isIE) {
		var el=dge('x_msgs_table');
		if(x_list.scrollHeight>x_list.offsetHeight){
			class_add(x_list,"hack_scroller");
			if(el) el.style.width=px(x_list.offsetWidth-15-1);
		}else{
			class_remove(x_list,"hack_scroller");
			if(el) el.style.width=px(x_list.offsetWidth-1);
		}
	}
}

function resize_right_column(xx)
{
	if(!showing_column3) return;
	var x_rp=dge('rcol');
	if(!x_rp || !x_rp.style) return;
	var rch=(xx['screen_h']-xx['ban_h']-panel_gap*2)-2;
#	Panel itself the right width
	x_rp.style.width=px(pref.sizer3-panel_gap);

	var x_todo=dge('todo_list');
	x_todo.style.height=px(rch /*- 200*/ - 7*2 -6 /*- 20*/);
	x_todo.style.width=px(pref.sizer3-panel_gap+14);
	var x_noscroll=dge('todo_noscroller');
	x_noscroll.style.width=px(pref.sizer3-panel_gap-2);

	right_column=pref.sizer3+panel_gap+2;
	var el=dge('todo_search_ip');
	if(el) el.style.width=px(pref.sizer3-panel_gap-6);
}


function fix_scroll_bars(xx)
{
	if (xx['screen_hh']<420 || pref.mode=='web'){
		class_add(document.getElementById('doc_html'),'html_scroll');
	}else{
		class_remove(document.getElementById('doc_html'),'html_scroll');
	}
}

function widescreen_menu()
{
	if(pref.preview=='horiz'){
		class_add(dge('search_controls'),'widescreen');
#		class_add(dge('navigator_outer'),'widescreen');
	}else{
		class_remove(dge('search_controls'),'widescreen');
#		class_remove(dge('navigator_outer'),'widescreen');
	}
}


# ***** Menu manager

function menubar_init(name){
	sw.menubar.menus=[];
	sw.menubar.menus["menu_bar_main"]=document.getElementById('menu_bar_main');
	sw.menubar.menus["menu_message"]=document.getElementById('menu_message');
	menu_set(name);
	if(name=='menu_bar_main'){
		var delta=||iftrue(force_button_disable)||0||else||4||endif||;
		var height = dge('mnu_reply').offsetHeight+delta;
		if(height<5) height=22;
		dge('menu_bar_main_height').style.height=px(height);
		toolbar_buttons_customise(pref.toolbar_buttons);
# 		customise other already defined toolbars too
		toolbar_buttons_customise2(pref.toolbar_buttons);
#		Start with the inbox being shown
		menu_custom_fld(1,'INBOX');
		widescreen_menu();
	}
}

function menu_set(id)
{
	var menubar=sw.menubar;
	if(id=='menu_compose'){
		dge('compose_info').innerHTML='';
	}else if(id=='chat_menu' && menubar.current && menubar.current.id=='chat_menu'){
		menu_none(id);
	}

#//	Nothing to do if we already have the correct menu
	if(menubar.current && menubar.current.id==id) {
		return;
	}

#//	Hide the current menu if there is one
	if (menubar.current){
		class_add(menubar.current,"hidden");
		menubar.current=undefined;
	}
	if (id==undefined || id==''){
		return;
	}

#//  Show the correct menu if we know about it
	var menu=menubar.menus[id];
	if (menu && menu.parentNode){
#		This is a bit of a hack and YUCK, but if the menu is not the first menu in the anchor div IE messages up some
#		 of the button placements in a really weird way
		if(menu!=menu.parentNode.firstChild){
			oldmenu=menu.parentNode.firstChild;
			menu.parentNode.insertBefore(menu,oldmenu);
		}
		class_remove(menu,"hidden");
		menubar.current=menu;
		return menu;
	}
#//  Setup theDOM node as a menu if we do not know about it yet
	menu=document.getElementById(id);
	if (menu){
		class_remove(menu,"hidden");
		menubar.appendChild(menu);
		menubar.menus[id]=menu;
		menubar.current=menu;
	}
	return menu;
}

function menu_custom_fld(type,name)
{
	if(name=='$$Notes$$')type=9;
	if(type==3){
		class_set(sw.menubar.current.firstChild,'main_menu_sent');
	} else if(type==2 || type==9){
		class_set(sw.menubar.current.firstChild,'main_menu_draft');
	} else {
		class_set(sw.menubar.current.firstChild,'main_menu_fld');
	}
}

var enInbox=1, enDraft=2, enSent=3, enTrash=4, enUser=5, enSpam=6, enMissing=7, enDone=8;	// QQQ NOTE
function menu_arrange(type)
{
	if(!menubar.current || menubar.current.id!='menu_bar_main')return;
#	class_add(menubar.current,'fld_menu_'+type)
}
function menu_none(id)
{
	var menubar=sw.menubar;
	var o=menubar.current;
	menubar.current=U;
	menubar.menus[id]=U;
	o.parentNode.removeChild(o);
}

# **** Misc initialisation

function background_init()
{
	if(pref.alt_ui) return;
	var x=pref_colour;
	if (!x.length>0) x='new';
	class_add(document.body,x);
	class_add(document.getElementById('top_banner'),x);
}

function clear_folder_menu(id)
{
	dge(id).firstChild.innerHTML='';
}

function toolbar_buttons_customise(show)
{
	var btns=[	'mnu_reply','mnu_reply_all','mnu_forward','mnu_forward_attach',
				'mnu_done','mnu_delete','mnu_spam','mnu_notspam',
				'mnu_compose','mnu_cache','mnu_move','mnu_test','mnu_print'];
	var p;
	for(var i=btns.length-1;i>=0;i--){
		el=dge(btns[i]);
		if(el){
			if(show.charAt(i)=='1'){
				class_remove(el,'hidden');
				el.default_hide=false;
			}else if(show.charAt(i)=='0'){
				class_add(el,'hidden');
				el.default_hide=true;
			}
			if(!p) p=el.parentNode;
		}
	}
	if (p)force_redraw(p);
}
function toolbar_buttons_customise2(show)
{
	var btns={'12':'mnu_print2', '13':'mnu_label', '14':'mnu_new_note', '15':'mnu_redirect'};
	var p;
	for(i in btns){
		el=dge(btns[i]);
		if(el){
			if(show.charAt(i)=='1')
				class_remove(el,'hidden');
			else if(show.charAt(i)=='0')
				class_add(el,'hidden');
			if(!p) p=el.parentNode;
		}
	}
#	if (p)force_redraw(p);
}
function toolbar_buttons_get()
{
	var s='';
	for(var i=0;i<16;i++){
		var el=dge('mbcust_'+(i+1));
		if(!el) s+='*';
		else if (el.checked) s+='1';
		else s+='0';
	}
	return s;
}

function toolbar_buttons_init(show)
{
	for(var i=0;i<17;i++){
		var el=dge('mbcust_'+(i+1));
		if(!el) continue;
		var c = show.charAt(i);
		el.checked=(c=='1'||c=='');
	}
}
function toolbar_custom_reset()
{
	toolbar_buttons_init('*0*00*0010000110');
}

function ie_fixfocus()
{
	if(!isIE) return;
	var el=dge('dummy_input');
	class_remove(el,'hidden');
	el.focus();
	class_add(el,'hidden');
}
function window_manager_altinit(node)
{
	var el = alt_dom2frame(node);
	if(el==U) return;

	el.compose_panel = node.popup_compose;

	var msg_panel = node;
	var compose_panel = msg_panel.childNodes[1];
	compose_panel.tbar_ref = el.firstChild.firstChild;

#	Drag.init(el,el);
}