if test $1
then
echo ""
else
echo ""
echo " usage:    surgeftp_ca.sh server-name cert-bits"
echo ""
echo " server-name    is DNS name of server."
echo " cert-bits      is number of bits for certificate, e.g. 128, 256, ... 2048"
echo ""
echo " output files:"
echo "   server-name.key        - your key generated from random.data"
echo "   server-name.de.key     - your key with pass code removed"
echo "   server-name.csr        - send this file only to certificate authority to order real CA certificate"
echo "   surge_priv.pem         - self signed & ready to use certificates for surgeftp"
echo "   surge_cert.pem         - self signed & ready to use certificates for surgeftp"
fi

if test -f random.data 
then

echo   Generate the Key from random data
openssl genrsa -des3 -rand random.data -out $1.key $2

echo   Generate Certificate Request
openssl req -config ./openssl.cnf -new -key $1.key -out $1.csr

echo   Generate a temporary self-signed Certificate
openssl x509 -req -days 365 -in $1.csr -signkey $1.key -out $1.crt

echo   remove passcode encryption, SurgeFTP does not currently have option for decoding this
openssl rsa -in $1.key -out $1.de.key

echo   create self signed key and certificate for SurgeFTP.
cp $1.de.key surge_priv.pem
cp $1.crt surge_cert.pem

else

echo Please create a file called random.data that has random
echo information in it, at least 2MB uncompressed or 50KB compressed,
echo it can be anything! but must be unique data.
echo We recomend creating large bitmap file with Paint program
echo maybe start with existing picture, draw lots of scriggles
echo on it in different colors, save it as random.png,
echo compress it with pkzip or arj or compress
echo or ace or any compresser you have.
echo then save final file as random.data
echo and then rerun surgeftp_ca.sh

fi


