(function(){

window.ink_test = ink_test;

||include||ink_nurbs.js||
||include||ink_bspline.js||
||include||ink_bezier.js||
||include||ink_bint.js||
||include||ink_bint2.js||

||include||ink_paper.js||

#var canvas2;

function ink_test( points, lines )
{
//	return;
	var sz = {px:486, py:486, x:486, y:486 };
	sz.scale = sz.px/sz.x;

	var order = 3;
	
	points = [
		{x:0,y:0}, 
		{x:sz.x/2,y:sz.y/2}, 
		{x:sz.x*0.8,y:sz.y*0.2},
		{x:sz.x*0.8,y:sz.y*0.8},
		{x:sz.x*0.2,y:sz.y*0.8},
	];

	var knots = [0,0,0, 0,1,2,3,4, 4,4,4];

	var weights = []
	
	assign_dynamic_css('ink_css', '||css_begin()||\		
		.ink_container_css{
			position:absolute;
			left: 0; right: 0; margin: auto; 
			width:'+(sz.x*2)+'px;
			height:'+(sz.y)+'px;
			z-index:1001;
		}
	||css_end()||');

	var el=create_element('div', 'ink_container');
	class_add(el,'ink_container_css');
	el.innerHTML='<canvas id="drawing_canvas" width="'+sz.x+'px" height="'+sz.y+'px"/ style="background:pink;_display:none;_position:_absolute;_top:0;_left:0;"> </canvas>'+
				 '<canvas id="drawing_canvas2" width="'+sz.x+'px" height="'+sz.y+'px" style="background:lightgreen;_position:absolute;_top:0;_left:500px;"> </canvas>';
	
	slide_in_upwards(el,800,2000);	
	
	var canvas = dge('drawing_canvas');
	var ctx = canvas.getContext("2d");

	window.canvas2 = dge('drawing_canvas2');

	ctx.lineWidth = 1;

	if (points.length<2) return;

//	ctx.clearRect(0,0, sz.x, sz.y);
	dbg('sz x='+sz.x+' y='+sz.y);

	window.draw_m = function()
	{
		// Control points draw
		ctx.moveTo(points[0].x, points[0].y);
		for(var i=1;i<points.length;i++){
			ctx.lineTo(points[i].x, points[i].y);
		}
		ctx.stroke();
	}
	draw_m();
	

// https://www.ibiblio.org/e-notes/Splines/basis.html

var type=9;
if(type==1){
  var c4 = new Bezier("drawing_canvas", "drawing_canvas2", 
  			.4, 
//  			[.1, .1, .8, .8, 0.5, 0.3],
//    		[.1, .8, .9, .2, 0.5, 0.6],
  			[.1, .1, .8, .8, .5, .3, .5, .9],
    		[.1, .8, .9, .2, .1, .5, .6, .3],
    	);
}else if(type==2){ 	
	// LOOP / NON LOOP bspline construct
	 var b4 = new Bspline("drawing_canvas", "drawing_canvas2", 
	 		.4, // 	scale
	 		5, 	// n = 5th degree   +1 => 6 control points 
	 		4, 	// k = 4th order 
	 		[.2,.8,.8,.2+0.02, .8+0.02,.8+0.02], 	// x positions
	 		[.9,.9,.2,.9+0.02, .9+0.02,.2+0.02],	// y positions	// closed shape overlapping points!
	    	[0,1,2,3,4,5,6,7,8,9],	// knots						// (4+6=10) order+degree(hops)+1  ==  order+pts  ==  (4+6=10)																		// Knots going to the end
//	    	[.0,.001,.002,  .003,1,2,3,  3.001,3.002,3.003],		// #order same @end
	    );	 		
}else if(type==3){	// STANDARD four pt bezier / bspline
 if(false){
  var b3 = new Bezier("drawing_canvas", "drawing_canvas2", 
  			.3, 
  			[.1, .3, .7, .9], 
  			[.1, .9, .9, .1]
  		);
 }else{  		   		
  var b1 = new Bspline("drawing_canvas", "drawing_canvas2", 
  			.3, 
  			3, 				// 4 ctl points => 4-1 = 3 = n => 3rd degree curve
  			4, 				// 4th order (cubic), third degree bspline
  			[.1,.3, .7,.9], 
  			[.1,.9, .9,.1],											// cubic bezier curve (minimal bspline)
   			[.0,.001,.002,	.003,1,  1.001,1.002,1.003],			// (4+3+1=8) order+(degree+1) == order+pts (4+4=8)
   		);
 }  	
// **** ----
}else if(type==4){	// Higher order bsplines and bezier curves 
 var tt=2;
 if(tt==1){
  var b3 = new Bspline("drawing_canvas", "drawing_canvas2", 	// Quadratic
  			.4, 
  			7, 	// n=7  // 7th degree => 8 ctl points
  			3,  // k=3 	quadratic, 3rd order										<<< bspline depends on k ctl points ONLY
  			[.1,.25,.4,.5,.6,.7,.8,.9], 	// 7+1
  			[.2,.2,.2,.9,.2,.2,.2,.2],
   			[.0,.001, .002,1,2,3,4,5,6, 6.001,6.002]	//7+2+2
   		);
 }else if(tt==2){
  var b4 = new Bspline("drawing_canvas", "drawing_canvas2", 	// Cubic
  			.4, 
  			7, 	// n=7  // 7th degree 
  			4, 	// k=4 cubic, 4th order 											<<< bspline depends on k ctl points ONLY
  			[.1,.25,.4,.5,.6,.7,.8,.9], 	// 8 (7+1)
  			[.2,.2,.2,.9,.2,.2,.2,.2],
   			[.0,.001,.002, .003,1,2,3,4,5, 5.001,5.002,5.003]	//4+7+1 = k + (7+1)
   		);
 }else if(tt==3){
  var b5 = new Bezier("drawing_canvas", "drawing_canvas2", 
  			.4, 
  			[.1,.25,.4,.5,.6,.7,.8,.9], 
  			[.2,.2,.2,.9,.2,.2,.2,.2]
  		);
 }
// **** ----
   	
}else if(type==5){  	  // interpolated bspline, calculater intermediate pts. really is piecewise bezier curve.
 var tt=2;
 if(tt==1){
  var c1 = new Bint("drawing_canvas", 	// explicit end pts
  			.4, 
  			[.05, .7, .9, .22, .83], 
  			[.7, .75, .05, .935, .2]
  		);
 }else{
		var c2 = new Bint2("drawing_canvas", 	// derived end pts
			.4,
		 	[.1, .2, .3, .4, .5, .6, .7, .8], 
		 	[.2, .2, .2, .9, .2, .2, .2, .2]
		 );
 }

}else if(type==6){ 	// Additional weighting per basis function
	 var n6 = new NURBS("drawing_canvas","drawing_canvas2", 
	 		.3, 
	 		8, 
	 		3, 														// <<< 1. Its a quadratic!!
	 		[.5, .1, .1, .1, .5, .9, .9, .9, .5],					// <<< 2. Control points have straight sections!
	 		[.1, .1, .5, .9, .9, .9, .5, .1, .1], 

//	 		[1, .71,  1, .71, 1, .71, 1, 0.71, 1],					// <<< 4. The non collapsed points have varied pull strength	
	 		[1, .7071,  1, .7071, 1, .7071, 1, 0.7071, 1],
//	 		[1, 1,  1, 1, 1, 1, 1, 1, 1],
//	 		[.71, .71,  .71, .71, .71, .71, .71, .71, .71],
//	 		[10, 10,  10, 10, 10, 10, 10, 10, 10],

	 		
//	 		[0.0, 0.001, 0.002,  .22,.251, .47,.51, .72,.751,  1, 1.001, 1.002],	// <<< 3. Every second ctl point is collapsed
	 		[0.0, 0.001, 0.002,  .25,.251, .50,.51, .75,.751,  1, 1.001, 1.002],
//	 		[0.0, 0.001, 0.002,  1,1.001,  2,2.001, 3,3.001,   4, 4.001, 4.002],

	 	);
}else if(type==7){ 	// Experimenting with Paper.js
	
#	paper.install(window);

	paper.setup(canvas);
	var path = new paper.Path();
	path.strokeColor = 'black';
	var start = new paper.Point(100, 100);
	path.moveTo(start);
	path.lineTo(start.add([ 200, -50 ]));
	path.lineTo(start.add([ 100, 100 ]));
	path.lineTo(start.add([ 90, 10 ]));
	paper.view.draw();

}else if(type==8){ 	// Experimenting with Paper.js
	window.paper = paper;
	paper.setup(canvas);
	paper.execute("||js_begin()||\

var textItem = new paper.PointText({
	content: 'Click and drag to draw a line.',
	point: new paper.Point(20, 30),
	fillColor: 'black',
});

var path;
var valid = false;
function onMouseDown(event) 
{
	valid = true;
	if (path) {
		path.selected = false;
	}

	path = new paper.Path({
		segments: [event.point],
		strokeColor: 'black',
		fullySelected: true
	});
}
function onMouseDrag(event) 
{	
	if(!valid) return;
	
	path.add(event.point);

	textItem.content = 'Segment count: ' + path.segments.length;
}

function onMouseUp(event) 
{
	var segmentCount = path.segments.length;

	path.simplify(10);

	path.fullySelected = true;
	valid = false;

	var newSegmentCount = path.segments.length;
	var difference = segmentCount - newSegmentCount;
	var percentage = 100 - Math.round(newSegmentCount / segmentCount * 100);
	textItem.content = difference + ' of the ' + segmentCount + ' segments were removed. Saving ' + percentage + '%';
}	
||js_end()||");


}else if(type==9){ 	// Experimenting with Paper.js
	window.paper = paper;
	var canvas2 = dge('drawing_canvas2');

	paper.setup(canvas2);
	paper.execute("||js_begin()||\

#// Please note: dragging and dropping images only works for
#// certain browsers when serving this script online:
var path, position, max;
var count = 0;
var grow = false;

#// As the web is asynchronous, we need to wait for the raster to
#// load before we can perform any operation on its pixels.
var raster = new Raster('/surgeweb/shared/img/xx/mona.jpg');
raster.visible = false;
raster.on('load', resetSpiral);

var text = new PointText({
	justification: 'right',
	fontSize: 12,
	content: window.FileReader
		? 'drag & drop an image from your desktop to rasterize it'
		: 'to drag & drop images, please use Webkit, Firefox, Chrome or IE 10'
});

function onFrame(event) {
	if (grow) {
		if (raster.loaded && (view.center - position).length < max) {
			for (var i = 0, l = count / 36 + 1; i < l; i++) {
				growSpiral();
			}
			path.smooth();
		} else {
			grow = false;
		}
	}
}

function growSpiral() {
		count++;
		var vector = new Point({
			angle: count * 5,
			length: count / 100
		});
		var rot = vector.rotate(90);
		var color = raster.getAverageColor(position + vector / 2);
		var value = color ? (1 - color.gray) * 3.7 : 0;
		rot.length = Math.max(value, 0.2);
		path.add(position + vector - rot);
		path.insert(0, position + vector + rot);
		position += vector;
}

function resetSpiral() {
	grow = true;

#	// Transform the raster, so it fills the view:
	raster.fitBounds(view.bounds);

	if (path)
		path.remove();

	position = view.center;
	count = 0;
	path = new Path({
		fillColor: 'black',
		closed: true
	});

	position = view.center;
	max = Math.min(raster.bounds.width, raster.bounds.height) * 0.5;
}

function onResize() {
	if (raster.loaded)
		resetSpiral();
	text.point = view.bounds.bottomRight - [30, 30];
}

function onKeyDown(event) {
	if (event.key == 'space') {
		path.selected = !path.selected;
	}
}

function onDocumentDrag(event) {
	event.preventDefault();
}

function onDocumentDrop(event) {
	event.preventDefault();

	var file = event.dataTransfer.files[0];
	var reader = new FileReader();

	reader.onload = function (event) {
		var image = document.createElement('img');
		image.onload = function () {
			raster = new Raster(image);
			raster.visible = false;
			resetSpiral();
		};
		image.src = event.target.result;
	};
	reader.readAsDataURL(file);
}

canvas2.addEventListener('dragover', onDocumentDrag, false);
canvas2.addEventListener('dragleave', onDocumentDrag, false);
canvas2.addEventListener('drop', onDocumentDrop, false);

||js_end()||");
}


}
})();
