# Marijn's benchmarking

var benchmarks=[];

# Some useful bechmarking functions
function benchmark(fn) { 
	dbg("begin benchmark x1"); 
	var s = mtime(); 
	fn(); 
	var e = mtime(); 
	dbg("elapsed time "+(e-s)); 
} 

function benchmark_n(fn,count) { 
	dbg("begin benchmark x"+count); 
	var s = mtime(); 
	var n = count;
	while (n--){ 
		fn(); 
	} 
	var e = mtime(); 
	dbg("elapsed time "+(e-s)+"ms ["+((e-s)*1000/count)+" microseconds per call]"); 
} 

function benchmark_begin(txt) { 
	dbg("benchmark begin ["+txt+"]"); 
	benchmarks[txt] = mtime(); 
}

function benchmark_end(txt) { 
	var e = mtime(); 
	
	var text="benchmark end ["+txt+"] elapsed:"+(e-benchmarks[txt])+"ms";
	dbg(text);
	return text;
}



# Originally devt location: ..\bench\bench.js
dbg("module Benchmark source file loaded");
