
// multi level popover for dialogs etc encapsulating the show hide in terms of 
// event handling positioning, resizing etc
// Author: M Weehuizen, June 2012


// pull stuff from : cal_showpopover

var Popover = {

	obj : null,
	pop_stack : [],

	init : function(o,opt)
	{
		o.popover_init = true;				
        dbg('fns Popover.init');
	},
	show : function(o, opt)
	{
		if(Popover.obj){
			Popover.pop_stack.push(Popover.obj);
			Popover.obj=U;
		}
	
		o.opt=Popover.checkopt(opt);
		o.style.zIndex=o.opt.zindex;
		
		Popover.init_position(o);
		Popover.init_shadofy(o);
		Popover.init_arrowfy(o);
		Popover.init_overlay(o);	
		Popover.obj = o;

		o.onmousemove=Popover.mousemove;		
		o.ondblclick=stopEvent;

		o.old_onmousemove	= document.onmousemove;
		o.old_onmousedown	= document.onmousedown;
		o.old_onkeydown		= document.onkeydown;

		document.onmousemove	= Popover.mousemove2;
#		document.onmousedown	= Popover.mousedown;
		document.onkeydown		= Popover.keydown;

		o.onPopoverClose = new Function();

        dbg('fns Popover.start');
	},
	end : function(o)
	{
        dbg('fns Popover.end');
        if(!o) o=Popover.obj;
        
		document.onmousemove = o.old_onmousemove;
		document.onmousedown = o.old_onmousedown;
		document.onkeydown = o.old_onkeydown;

		o.onPopoverClose(o);

        remove_node(o.ovrlay);
        remove_node(o);

        if(Popover.pop_stack.length>0){
			Popover.obj = Popover.pop_stack.pop();
        }else{
			Popover.obj = null;
        }
        
	},
	checkopt: function(opt)
	{
		if(!opt) opt={};
		if(!opt.zindex) opt.zindex=1000;
		if(!opt.offset) opt.offset=22;
		if(!opt.width) opt.width=330;
		opt.rise=0;
		return opt;
	},
	init_shadofy: function(o)
	{
		var opt=o.opt;
		if(opt.no_shadow) return;
		return shadofy(o);
	},	
	init_arrowfy: function(o)
	{
		var el, el2, opt=o.opt;
		if(o.arrowfied) return;
		var asize=opt.offset-2;
		el=new_element(o,'div');
		el.style.zIndex=+1;
		class_add(el,'hint_arrow_outer');
		el.style.width=px(asize*2); el.style.height=px(asize); 
		el.style.top=px(39+opt.rise); el.style[opt.to_left?'left':'right']=px(340); 
		if(opt.arrow) {		
			el2=new_element(el,'div');
			class_add(el2,'hint_arrow_border');
			el2.style.borderTop=el2.style.borderBottom='10px solid transparent';
			el2.style[opt.to_left?'borderRight':'borderLeft']='20px solid transparent';
			el2.style[opt.to_left?'borderLeft':'borderRight']='20px solid #777';
			el2=new_element(el,'div');
			class_add(el2,'hint_arrow_bg');	
			el2.style[opt.to_left?'right':'left']=px(3);
			el2.style.borderTop=el2.style.borderBottom='10px solid transparent';
			el2.style[opt.to_left?'borderRight':'borderLeft']='20px solid transparent';
			el2.style[opt.to_left?'borderLeft':'borderRight']='20px solid white';
			el2.onmousedown=arrow_mousedown;
		}
		o.arrow_el = el;
		o.arrowfied=true;		
	},
	init_overlay: function(o)
	{
		var opt=o.opt;
		var el=new_element(document.body,'div');
		el.style.zIndex=opt.zindex-1;
		class_add(el,'popover_ovrl');
		if(opt.overlay) class_add(el,'popover_ovrl_dark');
		o.ovrlay=el;
		o.ovrlay.onmousemove=Popover.ovrl_mousemove;
		o.ovrlay.onmousedown=Popover.ovrl_mousedown;
	},
	init_position: function(o)
	{
		var opt=o.opt;
		var ts=ClientHeight(), ws=ClientWidth();
		var xy=opt.xy;
		var el=opt.xy_el;
		if(el){
			var loc=get_location(el);
			var scroll=dge(opt.scroll_correct);
			loc.top-=scroll.scrollTop;
			var hdelta=(el.offsetHeight>100?64:el.offsetHeight/2);
			xy={x:loc.left+el.offsetWidth-10, y:loc.top+hdelta};
		}
	
		opt.to_left=false;
		var wp=o.offsetWidth;
		var l=xy.x+opt.offset;
		if(l+wp>ws-20){
			opt.to_left=true;
			l=l-wp-opt.offset*2;
			if(el){
				l=l-el.offsetWidth+20;
			}
		}
		o.style.left=px(l);

		var tp=o.offsetHeight;
		var t=xy.y-50;
		if(t+tp>ts-20){
			var rise=(t+tp)-(ts-20);
			t-=rise;
			opt.rise=rise;
		}
		o.style.top=px(t);
	},
	resize_height: function(o)
	{
		var new_height=o.firstChild.offsetHeight-10;
		o.style.height=px(o.firstChild.offsetHeight-10);
	},
	update_position: function(o)
	{
		var opt=o.opt;		
		var ts=ClientHeight(), ws=ClientWidth();
		var xy=opt.xy;
		var tp=o.offsetHeight;
		var t=xy.y-50;

		var new_rise=(t+tp)-(ts-20);
		if(new_rise<0) {
#			// No reposiotioning required			
			return;
		}

#		if(new_rise<=opt.rise) return;
		
		t -= new_rise;
		opt.rise = new_rise;

		o.style.top=px(t);
		o.arrow_el.style.top = px(39+opt.rise);
	},
	
# EVENT handlers...	
	keydown: function(e)
	{
		if (!e) e = window.event;
		var o = Popover.obj, opt=o.opt
		var ret=true;
		switch (e.keyCode){
			case vkEsc: 
				o.keyHit=vkEsc;
				Popover.end(o);
				ret=false;
				break;
			case vkEnter: 
				o.keyHit=vkEnter;
				Popover.end(o)
				ret=false;
				break;
		}
		stopBubble(e);
		return ret;
	},
	ovrl_mousemove : function(e)
	{
#		dbg('Popover overlay mm');
		if (!e) e = window.event;
		var o = Popover.obj, opt=o.opt
		if(!opt.modal) Popover.end(o);
		stopEvent(e);
		return true;
	},
	ovrl_mousedown: function(e)
	{
		if (!e) e = window.event;
		var o = Popover.obj, opt=o.opt;
		o.mouse_close=true;
		Popover.end(o);
		stopEvent(e);
	},

	mousemove : function(e)
	{
#		dbg('Popover mm');
		if (!e) e = window.event;
# Marijn don't remember what I am stopping. Disabled 20/5/21 to allow copy paste
#		stopEvent(e);
	},
	mousemove2 : function(e)
	{
#		dbg('Global mm (popover capture)');
		if (!e) e = window.event;
# Marijn don't remember what I am stopping. Disabled 20/5/21 to allow copy paste
#		stopEvent(e);
	}

};

function arrow_mousedown(){}
