function tz_offset(x)
{
	var d=new Date(x);
	return -d.getTimezoneOffset();
}

function lib_switchover_find_in_range(t1,t2,old_offset)
#Do a binary search to find switch-over time in this range.
{
	var tm;
	var offset;
	while(t1!=t2) {
		tm=t1+Math.floor((t2-t1)/2);
		offset=tz_offset(tm);
		if (offset==old_offset) {
			t1=tm+1;
		}
		else {
			t2=tm;
		}
	}
	return t1;
}

function lib_get_dst_switchover_times(start_from, max_results, max_days)
{
	var n=0;
	var t=start_from;
	var offset;
	var curr_offset=tz_offset(t);
	var diff;
	var at;
	var ret="";

	while(max_days>0 && n<max_results) {
		t+=60*60*24*1000*30;
		max_days-=30;
		offset=tz_offset(t);
		if (offset!=curr_offset) {
			diff=offset-curr_offset;
			at=lib_switchover_find_in_range(t-60*60*24*1000*30,t,curr_offset);
			ret=ret+" "+Math.floor(at/1000)+"="+diff*60;
			n++;
			curr_offset=offset;
		}

	}

	return ret;
}


function CalculateTZInfo()
# e.g. returns "+43200 1088119979 1096725600=+3600 1111237200=-3600"
{
	var d=new Date()
	var ret="";
	offset=-d.getTimezoneOffset();
	ret=""+offset*60+" "+Math.floor(d.valueOf()/1000);
	ret=ret+lib_get_dst_switchover_times(d.valueOf(),3,500);
	return ret;
}

