var radio2 = "move";

function Bint2(canvasId, scale, Px, Py){

var canvas, ctx, w,h,h1, d,d2,  dragId = -1, isMouseDown = false;
var n = Px.length, n1 = n+1;
var B0 = new Float64Array(26),  B1 = new Float64Array(26),
    B2 = new Float64Array(26),  B3 = new Float64Array(26);
var dx = [],  dy = [];
   canvas = document.getElementById(canvasId);
   ctx = canvas.getContext("2d");
   canvas.addEventListener('mousemove', drag, false);
   canvas.addEventListener('touchmove', drag, false);
   canvas.addEventListener('mousedown', start_drag, false);
   canvas.addEventListener('touchstart', start_drag, false);                                    
   canvas.addEventListener('touchend', stop_drag, false);
   window.addEventListener('resize', resize, false);
   document.addEventListener('mouseup', function(){isMouseDown = false;}, false);
   var t = 0;
   for (var i= 0; i< 26; i++){
     var t1 = 1-t, t12 = t1*t1, t2 = t*t;
     B0[i] = t1*t12; B1[i] = 3*t*t12; B2[i] = 3*t2*t1; B3[i] = t*t2;
     t += .04;}
   resize();

function findCPoints(){
  dx[0] = (Px[1] - Px[0])/3;  dy[0] = (Py[1] - Py[0])/3;
  dx[n-1] = (Px[n-1] - Px[n-2])/3;  dy[n-1] = (Py[n-1] - Py[n-2])/3;
  var Ax = [], Ay = [], Bi = [];
  Bi[1] = -.25;
  Ax[1] = (Px[2] - Px[0] - dx[0])/4;   Ay[1] = (Py[2] - Py[0] - dy[0])/4;
  for (var i = 2; i < n-1; i++){
   Bi[i] = -1/(4 + Bi[i-1]);
   Ax[i] = -(Px[i+1] - Px[i-1] - Ax[i-1])*Bi[i];
   Ay[i] = -(Py[i+1] - Py[i-1] - Ay[i-1])*Bi[i]; }
  for (var i = n-2; i > 0; i--){
   dx[i] = Ax[i] + dx[i+1]*Bi[i];  dy[i] = Ay[i] + dy[i+1]*Bi[i]; }
}

function drawSpline(){
  findCPoints();
  var step = 1/w, t = step;
  var scPx = new Float64Array(n), scPy = new Float64Array(n);
  var scDx = new Float64Array(n), scDy = new Float64Array(n);
  var X,Y;
  ctx.clearRect(0,0, w, h);
  ctx.lineWidth = d;
  ctx.strokeStyle = "#0000f0";
  for (var i = 0; i < n; i++){
   X = scPx[i] = Px[i]*w;   Y = scPy[i] = Py[i]*h;
   scDx[i] = dx[i]*w;   scDy[i] = dy[i]*h;
   ctx.strokeRect(X - d, h1 - Y - d, d2,d2);
  }
/*
  if ( n > 1 ){
   ctx.beginPath();  ctx.moveTo(scPx[0], h1 - scPy[0]);
   for (var i = 1; i < n; i++){
    ctx.lineTo(scPx[i-1]+scDx[i-1], h1 - scPy[i-1]-scDy[i-1]);
    ctx.lineTo(scPx[i]-scDx[i], h1 - scPy[i]+scDy[i]);
    ctx.lineTo(scPx[i], h1 - scPy[i]);
   }
   ctx.stroke();
  }
*/
  ctx.lineWidth = d2;
  ctx.strokeStyle = "#f00000";
  ctx.beginPath();  ctx.moveTo(scPx[0], h1 - scPy[0]);
  for (var i = 0; i < n-1; i++){
   for (var k = 0; k < 26; k++){
    X = (scPx[i]*B0[k] + (scPx[i] + scDx[i])*B1[k] +
      (scPx[i+1] - scDx[i+1])*B2[k] + scPx[i+1]*B3[k]);
    Y = (scPy[i]*B0[k] + (scPy[i] + scDy[i])*B1[k] +
      (scPy[i+1] - scDy[i+1])*B2[k] + scPy[i+1]*B3[k]);
    ctx.lineTo(X, h1 - Y);}
  }
  ctx.stroke();
}
function resize(){
#  h = w = Math.round(window.innerWidth * scale);
   h = canvas.height; w = canvas.width;
  h1 = h-1;
  d = Math.max(1, Math.round(w / 250));  d2 = d+d;
  canvas.width = w;  canvas.height = h;
  drawSpline();
}
function drag(ev){
  if (!isMouseDown) return;
  var c = getXY(ev);
  Px[dragId] = c[0];  Py[dragId] = c[1];
  drawSpline();
  ev.preventDefault();
}
function start_drag(ev){
  isMouseDown = true;
  if (radio2 == "move"){
   var c = getXY(ev);
   dragId = getPointId(c, n);
   drawSpline();}
  else if ( radio2 == "delete" ){
   var c = getXY(ev);
   var Id = getPointId(c, n);
   for (var i = Id; i < n + 2; i++){
    Px[i] = Px[i+1];  Py[i] = Py[i+1];}
   n1--; n--;
   drawSpline();} 
  else if ( radio2 == "add" ){
   var c = getXY(ev);
   var Id = getPointId(c, n) + 1;
   for (var i = n + 2; i > Id; i--){
    Px[i] = Px[i-1];  Py[i] = Py[i-1];}
   Px[Id] = c[0];  Py[Id] = c[1];
   n1++; n++;
   drawSpline();} 
  ev.preventDefault();
}
function stop_drag(ev){
  dragId = -1;
  ev.preventDefault();
}
function getPointId(c, kn){
   var Rmin = 2, r2,xi,yi, Id = 0;
   for (var i = 0; i < kn; i++){
    xi = (c[0] - Px[i]); yi = (c[1] - Py[i]);
    r2 = xi*xi + yi*yi;
    if ( r2 < Rmin ){ Id = i; Rmin = r2;}}
   return Id;
}
function getXY(ev){
  if (!ev.clientX) ev = ev.touches[0];
  var rect = canvas.getBoundingClientRect();
  var x = (ev.clientX - rect.left) / w,
      y = (h1 - (ev.clientY - rect.top)) / h;
  return [x, y];
}
} // end

