# Surgeweb "anycolor" newlook coloring module uses one colour to fully specify ui coloring

(function(){
	var obj = { 
		restore: anycolor_restore, persist: anycolor_persist, record_col: anycolor_record_col,
		style_css: anycolor_style_css, dom_styling: anycolor_dom_styling,
		config: plain_config
	};
	
	obj.wide_only = true;
	obj.cur_col_hsl = rgb2hsl(txt2col('#0091fb'));
	
	if(!string_empty(pref.newlook_anycolor)){
		anycolor_record_col(rgb2hsl(txt2col(pref.newlook_anycolor)));
	}

	// QQPALETTE

	function anycolor_record_col(col) 
	{
		obj.cur_col_hsl=col;
	}

	function anycolor_persist()
	{
	}
	
	function anycolor_restore()
	{
	}
	
	function anycolor_style_css(cs, opt)
	{
		dbg('called anycolor_style_css');
		cs.one_color = obj.cur_col_hsl;		
		var fn = newlook_modules[pref.newlook_layout].central_css; 
		if (!fn) return '';		
		return fn('anycolor', cs);
	}
	
	function anycolor_dom_styling(cs, opt)
	{	
		dbg('called anycolor_dom_styling anycolor');
		var col = obj.cur_col_hsl;
				
		safe_html_assign('custom_hsl_h', dp(col[hsl_h],3));
		safe_html_assign('custom_hsl_s', dp(col[hsl_s],3));
		safe_html_assign('custom_hsl_b', dp(col[hsl_b],3));
		safe_html_assign('custom_rgb', hsl_out(col));	
		safe_html_assign('modern_colours', modern_colours_populate(cs));

		var palette = sw.palette;
		if(palette){
			palette.set_color(col, opt.bypass)
			palette.render();
		}
	}

	function plain_config()
	{
		return '||html_begin()||\
	<div style="float:left;">
		<div onclick="pick_col(`#a45759`)" class="pick_swatch" style="background:#a45759;"></div>
		<div onclick="pick_col(`#a78558`)" class="pick_swatch" style="background:#a78558;"></div>
		<div onclick="pick_col(`#31552d`)" class="pick_swatch" style="background:#31552d;"></div>
		<div onclick="pick_col(`#5784a4`)" class="pick_swatch" style="background:#5784a4;"></div>
		<div onclick="pick_col(`#a457a3`)" class="pick_swatch" style="background:#a457a3;"></div>
		<br>
		<div onclick="pick_col(`#fb0008`)" class="pick_swatch" style="background:#fb0008;"></div>
		<div onclick="pick_col(`#ff9000`)" class="pick_swatch" style="background:#ff9000;"></div>
		<div onclick="pick_col(`#157a08`)" class="pick_swatch" style="background:#157a08;"></div>	
		<div onclick="pick_col(`#0091fb`)" class="pick_swatch" style="background:#0091fb;"></div>
		<div onclick="pick_col(`#fb00f8`)" class="pick_swatch" style="background:#fb00f8;"></div>
	</div>
	<div>
		<canvas id="palette_pane2" class="color-palette" width="200" height="40" style="margin-left:16px;"></canvas>
		<canvas id="palette_pane1" class="color-palette" width="200" height="40" style="margin-left:16px;"></canvas>
	</div>
		||html_end()||';
	}

	newlook_register('anycolor', 'select any colour', obj, {alt:false});
})();
