||define||allow_friends||true||

# Mapping of one step configuraiton to actual simplified values
ctl0_mapping = {
	'disabled':['deliver','deliver'], 
	'little_spam':['mark','mark'],
	'little_spam2':['spam','spam'],
	'lots_spam':['spam_confirm','mark'],
#	'lots_spam2':['spam_confirm','spam_confirm'],
	'child_account':['kidsafe','kidsafe'],
	'custom':['custom','custom']
}

# Values to set simplified spam controls
ctl_text = {
	'spam_onestep':{
		'disabled':'DISABLED - no spam filtering done',
		'little_spam':'Mark probable spam and deliver to Inbox',
		'little_spam2':'Mark probable spam and deliver to Spam folder',
#		'med_spam':'Deliver almost certain spam to Spam folder, likely spam marked to Inbox',
		'lots_spam':'Challenge almost certain spam, mark likely spam RECOMMENDED',
#		'lots_spam2':'Challenge almost certain and likely spam',
		'child_account':'All unknown senders blocked (kidsafe mode)',
		'custom':'Customised spam configuration active'
	}
}
if(document.usercgi_allow_friends){
	ctl_text.spam_handling_certain={
		'deliver':'Deliver unmarked to INBOX',
		'mark':'Mark as spam & deliver to INBOX',
		'spam':'Deliver to personal Spam folder',
		'spam_confirm':'Send challenge email (Recommended)',
		'reject':'Reject outright',
		'kidsafe':'All unknown senders blocked',
		'custom':'Custom - advanced settings changed...'
	},	
	ctl_text.spam_handling_likely={
		'deliver':'Deliver unmarked to INBOX',
		'mark':'Mark as spam & deliver to INBOX (Recommended)',
		'spam':'Deliver to personal Spam folder',
		'spam_confirm':'Send challenge email',
		'kidsafe':'All unknown senders blocked',
		'custom':'Custom - advanced settings changed...'
	}	
}else{
	ctl_text.spam_handling_certain={
		'deliver':'Deliver unmarked to INBOX',
		'mark':'Mark as spam & deliver to INBOX',
		'reject':'Reject outright',
		'custom':'Custom - advanced settings changed...'
	},	
	ctl_text.spam_handling_likely={
		'deliver':'Deliver unmarked to INBOX',
		'mark':'Mark as spam & deliver to INBOX (Recommended)',
		'custom':'Custom - advanced settings changed...'
	}	
}



# Array of allowed values of ctl2 based on ctl1 with the first being the preferred value
ctl2_allow = {
	'deliver':['deliver'],
	'mark':['mark','deliver'],
	'spam':['mark','deliver','spam'],
	'spam_confirm':['mark','deliver','spam_confirm'],
	'reject':['spam_confirm','deliver','mark','spam'],
	'kidsafe':['kidsafe'],
	'custom':['custom']
}

# Mapping of surgeweb spam configuration settings to core usercgi values
map_sw_2_core = function (val1, val2, w)
{
	dbg('*** map_sw_2_core')
	var vals=['list',0,0,0];
	var L=pref.rating_probable, C=pref.rating_certain, U=0;
	if (val1=='kidsafe' || val1=='kidsafe'){
		vals=['safe',0,L,0];
	}else if (val1=='deliver'){
		vals=['list',0,0,0];
	}else if (val1=='mark'){
		switch(val2){
			case 'deliver':		vals=['list',U,C,0]; break;
			case 'mark':		vals=['list',U,L,0]; break;
		}
	}else if (val1=='spam'){
		switch(val2){
			case 'deliver':		vals=['silent',C,C,0]; break;
			case 'mark':		vals=['silent',C,L,0]; break;
			case 'spam':		vals=['silent',L,L,0]; break;
		}
	}else if (val1=='spam_confirm'){
		switch(val2){
			case 'deliver':		vals=['smite',C,0,0]; break;
			case 'mark':		vals=['smite',C,L,0]; break;
			case 'spam_confirm':vals=['smite',L,0,0]; break;
		}
	}else if (val1=='reject'){
		switch(val2){
			case 'deliver':		vals=['list',0,0,C]; break;
			case 'mark':		vals=['list',0,L,C]; break;
			case 'spam':		vals=['silent',L,0,C]; break;
			case 'spam_confirm':vals=['smite',L,0,C]; break;
		}
	}else if (val1=='custom'){
		vals=['smite',C,L,0];
	}	
	
	w.friend_mode=vals[0];
	w.friend_smite=vals[1];
	w.spam_subject=vals[2];
	w.spam_bounce=vals[3];
	w.spam_store=0;
	w.spam_vanish=0;
}



# Mapping of core values to surgeweb spam configuration settings
map_core_2_sw = function (jval)
{
	dbg('*** map_core_2_sw')
	var L=pref.rating_probable, C=pref.rating_certain;

	var state=new Object();
	if (jval.friend_mode=='safe') return ['kidsafe','kidsafe'];
	if (jval.spam_store!=0 || jval.spam_vanish!=0) return ['custom','custom'];

#	If we are using reject then have most complicated set of options	
	if(jval.spam_bounce!=0){
		if(jval.spam_bounce!=C) return ['custom','custom'];		
		if (jval.friend_mode=='list'){
			if(jval.spam_subject==0) return ['reject','deliver'];
			if(jval.spam_subject==L) return ['reject','mark'];
			return ['custom','custom'];		
		}
		if (jval.friend_mode=='silent'){
			if(jval.friend_smite==L) return ['reject','spam'];
			return ['custom','custom'];		
		}
		if (jval.friend_mode=='smite'){
			if(jval.friend_smite==L) return ['reject','spam_confirm'];
			return ['custom','custom'];		
		}
		return ['custom','custom'];		
	}
	
	if (jval.friend_mode=='list'){
		if(jval.spam_subject==0) return ['deliver','deliver'];
		if(jval.spam_subject==C) return ['mark','deliver'];
		if(jval.spam_subject==L) return ['mark','mark'];
		return ['custom','custom'];		
	}

	if (jval.friend_mode=='silent'){
		if(jval.friend_smite==C) {
			if(jval.spam_subject==C) return ['spam','deliver'];
			else if(jval.spam_subject==L) return ['spam','mark'];
			else return ['custom','custom'];
		}
		if(jval.friend_smite==L && jval.spam_subject==L) return ['spam','spam'];
		return ['custom','custom'];		
	}

	if (jval.friend_mode=='smite') {
		if(jval.friend_smite==C) {
			if(jval.spam_subject==0) return ['spam_confirm','deliver'];
			else if(jval.spam_subject==L) return ['spam_confirm','mark'];
			else return ['custom','custom'];
		}
		if(jval.friend_smite==L) return ['spam_confirm','spam_confirm'];
		return ['custom','custom'];		
	}
	
#	state.avalue=(jval.spam_subject!=pref.rating_probable)?'disables':'';
	return ['custom','custom'];
}

# Simple spam controls to One step configuration mapping
map_ctls_to_ctl0 = function (state)
{
	var i,arr,val;
	val='custom';
	for(i in ctl0_mapping){
		arr=ctl0_mapping[i];
		if(arr[0]==state[0] && arr[1]==state[1]){
			val=i;
			break;
		}
	}
	return val;
}

extra_info = function (id,o)
{
	var S=' &nbsp;&nbsp; ';
	dge(id).innerHTML='CORE SETTINGS: spam_subject='+o.spam_subject+S+'friend_mode='+o.friend_mode+S+'friend_smite='+o.friend_smite+S+'spam_bounce='+o.spam_bounce
		+'<br>'
		+'ADDITIONAL: spam_body='+o.spam_body+S+'spam_ddpriv='+o.spam_ddpriv+S+'spam_ddfrom='+o.spam_ddfrom+S
		+'[ spam_store='+o.spam_store+S+'spam_vanish='+o.spam_vanish+' ]';
}
