# Surgeweb "dynamic" newlook coloring module, sets fully dynamic ui coloring based on same single color technique as anycolor

(function(){
	var obj = { 
		restore: dynamic_restore, persist: dynamic_persist, record_col: dynamic_record_col,
		style_css: dynamic_style_css, dom_styling: dynamic_dom_styling,
		config: dynamic_config
	};
	
	// pick_scheme
	
	obj.wide_only = true;
	obj.cur_col_hsl = rgb2hsl(txt2col('#ff0000'));

	function dynamic_record_col(col) 
	{
		obj.cur_col_hsl=col;
	}

	function dynamic_persist()
	{
	}
	
	function dynamic_restore()
	{
	}
	
	function dynamic_style_css(cs, opt)
	{
		dbg('called dynamic_style_css');
		cs.one_color = obj.cur_col_hsl;		
		var fn = newlook_modules[pref.newlook_layout].central_css; 
		if (!fn) return '';		
		return fn('anycolor', cs);
	}
	
	function dynamic_dom_styling(cs, opt)
	{	
		dbg('called dynamic_dom_styling');
		var col = obj.cur_col_hsl;
				
		safe_html_assign('custom_hsl_h', dp(col[hsl_h],3));
		safe_html_assign('custom_hsl_s', dp(col[hsl_s],3));
		safe_html_assign('custom_hsl_b', dp(col[hsl_b],3));
		safe_html_assign('custom_rgb', hsl_out(col));	
		safe_html_assign('modern_colours', modern_colours_populate(cs));

		var palette = sw.palette;
		if(palette){
			palette.set_color(col, opt.bypass)
			palette.render();
		}
	}

	function dynamic_config()
	{

		return '<p>Scheme = <a href="#" onclick="pick_scheme(1)">muted (2 color)</a> | <a href="#" onclick="pick_scheme(2)">annoying (2 color)</a> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+
			   'Speed: <a href="#" onclick="pick_scheme_speed(4)">ludicrous</a> | <a href="#" onclick="pick_scheme_speed(3)">fast</a> | <a href="#" onclick="pick_scheme_speed(2)">standard</a> | <a href="#" onclick="pick_scheme_speed(1)">slow</a>';
	}
		
	newlook_register('dynamic', 'dynamic', obj, {alt:false});
})();