# Formatting routines for the new API based surgemail communication that does all html formatting clientside

function format_info_icons(layout,o)
{
	var icons_html = '';
	if(not_blank(o.msg_secure)) icons_html+='<div class="msgline_lock_'+o.msg_secure+' as"></div>';
	if(o.msg_attach>0) icons_html+='<div class="msgline_clip as"></div>';
	if(o.msg_priority=='high') icons_html+='<div class="msgline_high as"></div>';
	if(o.msg_priority=='low') icons_html+='<div class="msgline_low as"></div>';
	return icons_html;
}
function format_list_entry(layout,o)
{
	var date_html = '<span class="md wxc" title="'+format_date_detail(o.timestamp)+'">'+format_date_basic(o.timestamp)+'</span>';
	var from_html = '<a class="wide_to better_wide" style="font-size:1.1em;" title="'+o.rcpt_tt+'">'+xencode(o.rcpt)+'</a>';
	var size_html = '<span class="wxc">'+format_size_basic(o.size)+'</span>';
	var icons_html = format_info_icons(layout,o);

	var labels_html = '';
	for(var i=0; i<o.labels.length; i++){		
		var lbl = o.labels[i];
		labels_html+='<div class="ar as" label_id="'+xencode(lbl.label_name)+'"><div class="at" style="background-color: '+lbl.label_bg+'; border-color: '+lbl.label_bdr+';"><div class="au" style="border-color:'+lbl.label_bdr+';"><div class="av" style="color: '+lbl.label_col+';">'+xencode(lbl.label_name)+'</div></div></div></div>';
	}
	var comment_html = '';
	if(pref.devt_mode){
		comment_html+='<div class="ar asl"><div class="at"><div class="au"><div class="av">'+o.msg_id+'</div></div></div></div> ';
	}
	if(o.comment.length>0){
		comment_html+='<div class="ar asl"><div class="at" style="background-color: #EAEA1B; border-color: #EAEA1B;"><div class="au" style="border-color:#EAEA1B"><div class="av">'+xencode(o.comment)+'</div></div></div></div>';
	}

	var html = '';
	// QQHTML
	if(layout==LWide){
		html += '||html_begin()||\
<tr class="msgs_line '+o.gui_flags+'" from_email="'+o.from_email+'" timestamp="'+o.timestamp+'" msg_id="'+o.msg_id+'">
	<td class="mi" valign="center"><div class="wide_itm"><div class="'+o.gui_star_flags+' x_replied"></div></div></td>
	<td class="mi" style="padding:5px; padding-left:3px;">
		<div class="wide_icons" style="position:relative;height:1px;width:1px;"><input style="position:absolute;left:-22px;top:1px;" type="checkbox" id="sel_'+o.msg_id+'" /></div>
		<div class="mi" style="padding-top:1px;"><div class="xtrim"><div class="xwide">
			<div class="date_etc" style="float:right;">'+ift(fp.show_fld,'<a class="wide_fld" title="'+xencode(o.msg_fld)+'" style="font-style:italic;">'+xencode(o.msg_fld)+'</a> &nbsp;')+date_html+'</div>
			<div class="infoicons" style="margin-right:10px;">'+icons_html+'</div>
			'+from_html+'
		</div></div></div>
		<div class="mi" style="padding-top:1px;"><div class="x_trim"><div class="x_wide">
			<div style="float:left;"></div>
			<div class="date_etc" style="float:right;">'+size_html+'</div>
			<div class="xwide" style="padding-top:1px;"><a class="wide_subj">'+xencode(o.subject)+'</a></div>
		</div></div></div>
		<div class="mi"><div class="snippet_outer_wide" style="height:28px;">
			<span class="snippet">'+xencode(o.snippet)+'</span>
		</div></div>
		<div class="mi"><div class="xtrim"><div class="xwide">
			<div class="labels" style="float:right;"> '+labels_html+'</div>
			<div class="comment">'+comment_html+'</div>
		</div></div></div>
	</td>
</tr> ||html_end()||';
	} else if (layout==LTall){
		html += '||html_begin()||\
#	<tr class="nonselect_row"><td colspan="7" class="separator_left">||msg_separator||</td></tr>
#    <tr class="custom_row"><td colspan="3"></td><td colspan="4">Unselectable custom list item (eg title, grouping, advert, or whatever)</td></tr>
# also msg_draft and msg_todo were part of widescreen??
<tr class="msgs_line '+o.gui_flags+'" from_email="'+o.from_email+'" timestamp="'+o.timestamp+'" msg_id="'+o.msg_id+'">
	<td class="mi" valign="top"><div style="margin-top:2px;"><div class="'+o.gui_star_flags+'"></div></div></td>
	<td class="mi"><input type="checkbox" id="sel_'+o.msg_id+'" /></td>
	<td class="mi"><div class="x_replied"></div></td>
	<td class="mi"><div class="xtrim"><div class="xwide"><a title="'+o.rcpt_tt+'">'+xencode(o.rcpt)+'</div></div></td>	
	<td class="mi"><div class="xtrim"><div class="xwide">
		<div style="float:left;">'+comment_html+'</div>
		<div class="infoicons">'+icons_html+'</div>
		<div class="labels" style="float:right;">'+labels_html+'</div>
		<div class="xwide2"><a> '+xencode(o.subject)+'</a> '+ift(true,'<span class="snippet">&nbsp;&nbsp; '+xencode(o.snippet)+' </span>')+'</div>
	</div></div></td>
		'+ift(fp.show_fld,'<td class="mi"><div class="xtrim"><div class="xwide"><a title="'+xencode(o.msg_fld)+'">'+xencode(o.msg_fld)+'</a></div></div></td>')+'
	<td class="ms">'+format_size_basic(o.size)+'</td>
	<td class="md" title="'+format_date_detail(o.timestamp)+'">'+format_date_basic(o.timestamp)+'</td>
</tr> ||html_end()||';
	}
	return html;
}


function msg_list_body(layout, arr)
{
	var txt = '';
	for (i in arr){
		txt+=format_list_entry(layout,arr[i]);		
	}
	return txt;
}
function msg_list_suffix(layout,arr)
{
	var html='';
	if (arr.length==0) {
		html += '<div class="nomessages">$$st_info_nomsg_fld$$</div>';
	} else {
		if(layout==LWide){
			html += '<div id="msglist_dots" class="widescreen_dots"></div>';
			html += '<div class="msglist_nav">$$st_displayed$$ <span id="msg_navigator_wide"></span></div>';
		}else if (layout==LTall){
			html += '<div id="msglist_dots" class="tallscreen_dots"></div>';
		}
	}
	return html;
}

var LWide = 1; 
var LTall = 2;
function display_layout()
{
	var layout = 0
	if(pref.preview=='horiz') layout=1;
	if(pref.preview=='vert') layout=2;
	return layout;
}
var fp = {};
function setMessagesApi(o)
{
	var prefix=msg_text=suffix='';
	var layout=display_layout();
	fp.show_fld=o.search_result;
	
	if(layout==LWide){
# PREFIX WIDESCREEN
		prefix='||html_begin()||\
<span>
<table id="x_msgs_table" class="msgs_table wide_list wide_new_format" style="width:100%;table-layout:fixed;">
 <colgroup>
  <col style="width:22px;"><col style="width:100%;">
 </colgroup>||html_end()||';

	}else if (layout==LTall){	
# PREFIX TALLSCREEN
		prefix='||html_begin()||\
<span>
<table id="x_msgs_table" class="msgs_table tallscreen_list " style="width:100%;table-layout:fixed;">\
 <colgroup>
	<col style="width:16px;"><col style="width:20px;"><col style="width:15px;"><col style="width:28%;"><col style="width:60%;">
	'+ift(fp.show_fld,'<col style="width:60px;">')+'<col style="width:50px;"><col style="width:70px;">
 </colgroup>||html_end()||';
	}

	msg_text = msg_list_body(layout,o.msgs);
	suffix = '</table>'+ msg_list_suffix(layout,o.msgs)+'</span>';
	
	setMessages(prefix, msg_text, suffix);
}