# ****************************************************************************
# Surgeweb javascript - Self contained reusable GUI controls
# ----------------------------------------------------------------------------
# ****************************************************************************


#obj date_picker (calendar bits & updating, date display out
var PDate = {
	init : function()
	{
		var o = {};
		o.xc = cal_new();
		o.xc.cur_view = 'day';
		o.xc.sfn_delta = 'PDate.delta';
		o.xc.sfn_day = 'PDate.day';
		cal_curdelta(o.xc,0,0,7);
		return o;
	},
	ctl_html : function (o)
	{
		var html = '<div class="PDate"><div style="padding:5px;">3 December 2014</div><div>';
		html += cal_mini_days(o.xc);
		html += '</div></div>';
		return html;
	},
	to_date: function(el)
	{
		return el.childNodes[0];
	},
	to_cal: function(el)
	{
		return el.childNodes[1];
	},
	view_show: function(o){
		PDate.refresh(o);
	},
	set_dayoffset: function(o,dd){
		cal_thisdelta(o.xc,0,0,dd);
		PDate.refresh(o);
	},
	delta: function (e,ctl,dy,dm,dd)
	{
		var o = oo(ctl,'PDate');
		cal_curdelta(o.xc,dy,dm,dd);
		PDate.refresh(o);
	},
	day: function (e,ctl)
	{
		var o = oo(ctl,'PDate');
		cal_update_xc(e,o.xc);	// cf swcal_nav
		PDate.refresh(o);
		if(o.onchanged) o.onchanged(o,'o.value');
	},
	refresh: function(o)
	{
		var xc = o.xc;
		PDate.to_date(o.root).innerHTML = xc.cur_day+' '+xc.MofYf[xc.cur_month-1]+' '+xc.cur_year;
		PDate.to_cal(o.root).innerHTML = cal_mini_days(o.xc);
	},
	is_weekend: function(o)
	{
		var xc = o.xc;
		var dow = new Date(xc.cur_year, xc.cur_month-1, xc.cur_day).getDay();
		if(dow==0 || dow==6) return true;
		return false;
	},
	day_offset: function(o)
	{
		var xc = o.xc;
		return cal_cur_offset(xc);
	}
};

#obj time_picker (focus, dropdown display, etc) 
var PTime = {
	init : function()
	{
		var o = {};
		return o;
	},
	ctl_html : function (o)
	{
		var t,ap;
		var html='<div class="PTime hidden">'+
				  '<div><input value="8:00 am" style="width:73px;background:#ddd;padding:3px;padding-right:20px;text-align:right;" onfocus="PTime.focus(event,this)" onblur="PTime.blur(event,this)"  onkeyup="PTime.keyup(event,this)"></div>'+
				  '<div><ul id="llist" class="hidden" style="height:115px;width:100px;overflow-y:auto;background:white;margin:0;padding:0;text-align:right;">'
		for(var i=0;i<24;i++){
			t=i;
			ap='am';
			if(t==0) {
				t=12;
			}else if(t>=12){
				ap='pm';
				if(t>12) t=t-12;
			}
			for(var j=0;j<60;j+=30){
				html+='<li style="padding-right:5px;" offset='+(i*60+j)+' onmousedown="PTime.picked(event,this)" >'+t+':'+zero_prefix(j)+' '+ap+'</li>';
			}
		}
		html+=	  '</ul></div>'+
				 '</div>';
		return html;
	},	
	to_input: function (el){
		return el.childNodes[0].firstChild;
	},
	to_list: function (el){
		return el.childNodes[1].firstChild;
	},
	apply_input: function(o)
	{
//		o.value=value;
		if(o.onchanged) o.onchanged(o,o.value)
	},
	focus: function (e,ctl)
	{
		var o=oo(ctl,'PTime');
		var list = PTime.to_list(o.root)
		class_remove(list,'hidden');
		list.scrollTop = list.scrollHeight/24*7.5;
	},
	blur: function (e,ctl)
	{
		var o=oo(ctl,'PTime');
		class_add(PTime.to_list(o.root),'hidden');
	},
	keyup : function(e,ctl)
	{
		var o=oo(ctl,'PTime');
		return stopEvent(e);
	},
	picked: function (e,ctl){
		var o=oo(ctl,'PTime');
		PTime.set_time(o,ctl.getAttribute('offset'));
		PTime.apply_input(o);
	},
	set_time: function(o,offset){
		var val = PTime.list_item(o,offset);
		if(!val) {
			offset = 480;
			val = PTime.list_item(o,offset);
		}
		var ip=PTime.to_input(o.root);
		ip.value=val;
		o.value=offset;
	},
	list_item: function(o,offset){
		var list=PTime.to_list(o.root)
		for(i in list.childNodes){
			el=list.childNodes[i];
			if(!el || !el.tagName) continue;
			var tag=el.tagName.toLowerCase();
			if(tag=='li' && el.getAttribute('offset')==offset){
				return el.innerHTML;
			}	
		}
		return U;
	}
	
};

#obj duration_picker (calc offset duration)
var PDuration = {
	init : function()
	{
		var o = {};
		return o;
	},
	ctl_html : function (o)
	{
		return '<div class="PDuration"><div>$$ctl_duration_pick$$</div><div><input type="text" style="width:165px;" onkeyup="PDuration.keyup(event,this)"></div></div>';
	},
	to_input: function (el){
		return el.childNodes[1].firstChild;
	},
	keyup: function(e,ctl)
	{
		var o=oo(ctl,'PDuration');
		switch (e.keyCode){
		case vkEnter:
			PDuration.apply_input(o);
			break;
		}		
		return stopEvent(e);
	},
	apply_input: function(o)
	{
		var ip=PDuration.to_input(o.root)
		if(ip.value.length==0){
			if(o.oncomplete) o.oncomplete(o);
			return;
		}
		
		var value=parseInt(ip.value);
		var c = first_alpha(ip.value.toLowerCase());
		ip.value='';
		if(c=='w') value*=7;
		if(c=='m') value*=30;
		if(c=='y') value*=365;
		o.value=value;
		if(o.onchanged) o.onchanged(o,o.value)
	},
	day_offset: function(o)
	{
		return o.value;
	},
	focus: function(o)
	{
		PDuration.to_input(o.root).focus();
	}
};




#obj whole_control (layout & interactions => one number out)
var PDefer = {

	init : function(el,opt)
	{
		var o = {}
		PDate.init(o);
		// tie to el & build html
		o.root = el;
		PDefer.view_load(o);
		PDefer.view_show(o);
		return o;
	},
	ctl_html : function (o)
	{
		return  '<div style="float:right;width:100px;margin-right:20px;margin-top:-2px;">'+PTime.ctl_html(o)+'</div>'+
				'<div style="width:170px;height:170px;">'+PDate.ctl_html(o.pdate)+'</div>'+
				'<div style="width:300px;">'+PDuration.ctl_html(o)+'</div>';
	},
	view_load: function(o){
		o.ptime = PTime.init();
		o.pdate = PDate.init();
		o.pduration = PDuration.init();
		o.root.innerHTML = PDefer.ctl_html(o);
		var el = o.root;
		ooc(o,'ptime',el.childNodes[0].firstChild);
		ooc(o,'pdate',el.childNodes[1].firstChild);
		ooc(o,'pduration',el.childNodes[2].firstChild);
		o.pdate.onchanged = function(ctl,v){ PDefer.apply_day_change(o,'cal');};
		o.pduration.onchanged = function(ctl,v){ 
			PDefer.apply_day_change(o,'duration');};
		o.pduration.oncomplete = function(ctl,v){ 
			if(o.oncomplete) o.oncomplete();};
	},	
	view_show: function(o)
	{
		PDate.view_show(o.pdate);
		setTimeout(function(){ PDuration.focus(o.pduration); },250);
	},
	apply_day_change: function(o, type){
		if(type=='duration'){
			var offset = PDuration.day_offset(o.pduration)
			PDate.set_dayoffset(o.pdate,offset);
		}
		// retrieve day of week
		var weekend = PDate.is_weekend(o.pdate);
		PTime.set_time(o.ptime,weekend?600:480);
	},
	day_offset: function(o)
	{
		return PDate.day_offset(o.pdate);
	}

}