# Surgeweb newlook module that implements the newlook "minimalist" look

(function(){
	var menu_loud_col=[0,0,0,0];
	var menu_faded_col=[0,0,0,0];

	var obj = {
		alt_ui_interface:alt_ui_plain_interface, resize:alt_ui_plain_resize, config: plain_config,
		msglist_unsearch:msglist_unsearch,
		central_css:central_css, populate_message:populate_message, update_folder_state: update_folder_state
	};

	function alt_ui_plain_interface()
	{
		var el = alt_ui_prep();

#	Setup structure using HTML
		el.innerHTML='||html_begin()||\
			<div id="gradient_banner"></div>
# 			Menu and search area topleft
			<div style="width:200px;height:64px;overflow-y:none;position:absolute; left:0px;top:0px;">
			 <div id="search_etc" class="_faded_color" style="">
			 	<div id="alt_ui_settings" style=""><img src="||one_pix||" class="altui_burger"></div>
			 	<div id="alt_ui_search_box" class="_faded_color search_aligned" style="">
			 		<img src="||one_pix||" class="altui_search">\
					<div id="alt_ui_search_hint" value="Search">Search</div>\
					<input id="alt_ui_search" onfocus="if(!this.valid) search_field_set(``)">\
			 		<div class="altui_search_clear" onclick="newlook_search_reset();" style="padding:5px;left:354px;"><div class="altui_search_clear_img" style="width:24px;height:24px;"></div></div>\
			 	</div>
#				<img src="||www_base||shared/img/altui_loading3.gif" style="position:absolute;right:4px; height:38px; width:38px; top:4px;">\
			 	<div id="alt_ui_search_param" class="hidden" style="position:absolute;height:44px;left:0px;right:0px;padding:15px; text-align:center;">
			 		Searching:
			 		<a id="alt_ui_search_inbox" href="#" style="border:1px solid black;padding:4px;border-radius:3px;margin-right:10px;margin-left:10px;text-decoration:none;" onclick="do_search_folders(`single`,`folder`)">Inbox</a>
			 		<a id="alt_ui_search_recent" href="#" style="border:1px solid black;padding:4px;border-radius:3px;margin-right:10px;text-decoration:none;" onclick="do_search_folders(`recent`,`folder`)">Recent Folders</a>
			 		<a id="alt_ui_search_all" href="#" style="border:1px solid black;padding:4px;border-radius:3px;margin-right:10px;text-decoration:none;" onclick="do_search_folders(`all`,`folder`)">All Folders</a>
#			 		<a href="#" style="padding:4px;border-radius:3px;margin-right:10px;text-decoration:none;">Advanced...</a>
			 	</div>
			 	<div id="alt_ui_separator" style=""></div>
			 </div>
			</div>

			 <div id="alt_buttons_top" class="alt_buttons_top alt_buttons _faded_color" style="position:absolute;top:0;">
# centered img button
#				<div id="toolbar-reply-menu" class="alt_button" onclick="do_compose()"><img src="||www_base||shared/img/1pixel.gif" class="alt_popout" onclick="popout_edit()" title="$$st_cmd_popout_tt$$" align="middle"></div>

				<div id="altmenu_reply" class="alt_button" onclick="do_reply()" title="Reply (R)"><img src="||one_pix||" class="std_img reply"></div>
				<div id="altmenu_archive" class="alt_button" onclick="do_move_actual(pref.special_done);" title="Archive (=)"><img src="||one_pix||" class="std_img archive"></div>
				<div id="altmenu_delete" class="alt_button" onclick="do_delete()" title="Delete (Del)"><img src="||one_pix||" class="std_img trash"></div>
				<div id="altmenu_spam" class="alt_button" onclick="do_spam()" title="Spam"><img src="||one_pix||" class="std_img spam"></div>
				<div id="altmenu_moveto" class="alt_button" onclick="move_menu(event,`button`);" title="Move to Folder (M)"><img src="||one_pix||" class="std_img move"></div>
				<div id="altmenu_compose" class="alt_button" onclick="do_compose()" title="Compose Message (N)"><img src="||one_pix||" class="std_img compose_btn"></div>
				<div id="altmenu_more" class="alt_button" onclick="do_more_show(event)" title="More Actions (.)"><img src="||one_pix||" class="std_img more_btn"></div>
 			 </div>
#			 <div id="alt_buttons_prescroll" class="hidden" style="position:absolute; top:0px; left:360px; padding-right:5px; font-weight:bold;" >Message Subject</div>


			<div id="alt_buttons_links" style="position:absolute; top:0px; right:0px; padding-right:5px;z-index:1;" >\
				<a href="#" class="plain_link" onclick="do_menu_show(`top_menu_options`,event,true)">'+email+'</a> | \
				<span id="options_mnu" href="#" onmousedown="do_menu_show(`top_menu_options`,event,true,U,{xoffset:-25})" unselectable="on" onclick="return stopEvent(event)">$$st_cmd_options$$<img src="||www_base||shared/img/1pixel.gif" class="dropdown"></span> | \
#				<a href="||help_url||||iftrue(help_context)||/ajax.htm||help_extra||||endif||" target="_help">$$st_cmd_help$$</a> | \
				<a onclick="do_logout(``)">Log out</a></div>

# 			Left folders list display
			<div class="nano" style="position:absolute;overflow:hidden;left:0px;background:white;">
			 <div id="folders_section" class="nano-content" style="overflow-y:auto;overflow-x:hidden;position:absolute;-webkit-overflow-scrolling:touch; top:0;left:0;right:0;bottom:0;" onscroll="message_scrolled(event);">
			  <div id="folders" class="fldlist_color" style="_background-color:#ddeefb;"></div>
			 </div>
			</div>
   			<div id="accounts" class="hidden" unselectable="on" onmousedown="return stopEvent(event);"></div>\
		 	<div id="app_menu" style="_background:white;_z-index:1000; position:absolute; bottom:0px; _height:44px;" class="lpanel_buttons fldlist_color">
		 		<span id="pre_menu"></span>
				<input id="app_mail" type="button" onclick="app_menu(`mail`,this)" value="$$st_cmd_appmenu_mail$$" class="mnu">
				<input id="app_calendar" type="button" onclick="app_menu(`calendar`,this)" value="$$st_cmd_appmenu_calendar$$" class="mnu">
				<input id="app_contacts" type="button" onclick="app_menu(`contacts`,this)" value="$$st_cmd_appmenu_contacts$$" class="mnu">
 				<input id="app_theme" type="button" onclick="app_menu(`theme`,this);" value="$$st_cmd_appmenu_theme$$" class="mnu no_outline">
			</div>

# 			Center/left message list display
			<div class="nano animated_pos faded_color" style="position:absolute;;overflow:hidden;left:200px;_background:#f9f9f9;">
			 <div id="messages_list_section" class="nano-content" style="overflow-y:scroll;overflow-x:hidden;position:absolute;-webkit-overflow-scrolling:touch; top:0;left:0;right:0;bottom:0;" onscroll="message_scrolled(event);">
			  <div id="list_extra" class="hidden"></div>
			  <div id="messages_list" class="faded_color" style="_background-color:#f9f9f9; ||iftrue(alt_scroll)||overflow-y:scroll;||endif||"
					onmousedown="return msg_list_mousedown(event);" onmouseup="return msg_list_mouseup(event);" onclick="return msg_list_click(event);" ondblclick="msg_list_dblclick(event)" oncontextmenu="return false;"
					ontouchstart="touchStart(event);" ontouchmove="touchMove(event); event.stopPropagation();" ontouchend="touchEnd(event);" ontouchcancel="touchCancel(event);"> </div>
 		 	 </div>
			</div>

#			Right column (primarily message display)
			<div class="nano" style="overflow:none;position:absolute; left:500px;">
			 <div id="message_preview" class="nano-content" style="background-color:white;" onscroll="message_scrolled(event);"></div>
			</div>

# 			Extras

			<div class="alt_scrubber" style="width:5px;height:100%;position:absolute; left:500px;top:0px;_cursor:col-resize;">
			 <div id="alt_scrubber_bar" style="width:2px;height:100%; border-right:1px solid #ddd;"></div>
			</div>

			<div id="alt_status_container"><table><tr><td><div id="status" class="hidden"></div></td></tr></table></div>

			<div id="alt_gray_overlay" class="hidden"> </div>

#			<div id="alt_slideup" class="hidden alt_slideup">
#			  <div class="" style="_background:pink; width:100%; height:100%;">
			  	<div id="lpanel_hdr_alt" class="hidden faded_color" style="position:absolute;height:36px;width:200px; padding-top:7px; padding-left:10px;font-size:26px;border-bottom:1px solid #ccc;top:0px;"> Contacts </div>
				<div id="lpanel_contacts_alt" class="hidden" style="position:absolute;background:#ddeefb;left:0px;top:44px;height:80%;width:200px;"></div>
				<div id="lpanel_calendar_alt" class="hidden" style="position:absolute;background:#ddeefb;left:0px;top:44px;height:80%;width:200px;"></div>
			  	<div id="utility_menubar" class="hidden faded_color"  style="position:absolute;height:33px;border-bottom:1px solid #ccc; left:200px;top:0; right:0; _font-size:18px;padding-top:10px;padding-left:10px;padding-right:20px;"></div>
				<div id="utility_alt" class="hidden"  style="position:absolute;background-color:white; left:200px; right:0px; bottom:0px; top:44px; /*overflow-y:auto;*/"></div>
#			  </div>
#			</div>
			||html_end()||';

//			dge('messages_list').style.height='400px';

#	// Setup look using dynamic CSS
		assign_dynamic_css('newlook_altui_css', '||css_begin()||\
			#search_etc{
				_background:white;
				height:44px;
			}
			#alt_ui_settings{
				width: 500px; height:44px;
				position:absolute; top:0; left:0;
				_background:#f9f9f9;;
				_padding:10px; overflow:hidden;
			}
			#alt_ui_settings img, #settings_panel img{
				width:42px; height:42px;
				position:absolute; top:2px; left:6px;
#				width:32px; height:32px;
#				position:absolute; top:6px; left:10px;
			}
			#alt_ui_search_box{
				width:304px; height:44px;
				position:absolute; top:0; left:60px;
				border-left:1px solid #ccc; _background:#f9f9f9;;
				overflow:hidden;
			}
			#alt_ui_search_box.search_aligned{
				left:199px;
			}
			#alt_ui_search_box .altui_search{
				width:42px; height:42px;
				position:absolute; top:0px; left:2px;
			}
			#alt_ui_search_box div{
				position:absolute; top:12px; left:50px;
				color:#ccc;
				font-size:20px;
			}
			#alt_ui_search_box input{
				position:absolute; top:8px; left:50px; right:10px;
				border:none; outline:none; background:none;
				font-size:18px;
			}
			#alt_ui_search_box .altui_search_clear{
				width:42px; height:42px;
				position:absolute; top:0px; right:0px;
			}
			#alt_ui_actions{
				width: 500px; height:44px;
				position:absolute; top:0; left:440px;
				border-left:1px solid #ccc; background:#f9f9f9;;
				_padding:10px; overflow:hidden;
			}
			#alt_ui_actions img{
				width:32px; height:32px;
				position:absolute; top:6px; left:10px;
			}
			#alt_ui_separator{
				width: 600px; height:1px;
				position:absolute; top:44px; left:0px;
				border-top:1px solid #ccc;
			}
			.folder_toggle{
				width:16px;height:16px;
				border-right:1px solid #ccc;
				padding:2px;
			}
			.animated_resize {
				transition:all 0.3s ease-out;
			}
			.alt_scrubber{
				width:5px;height:100%;
				position:absolute; top:0px; left:500px;
#				cursor:col-resize;
			}
			.alt_scrubber_bar{
				width:2px;height:100%;
				border-right:1px solid #ddd;
			}
			.alt_compose_frame{
				box-shadow: 0px 0px 20px #000;
#				border:2px solid blue;
			}

			#messages_list a{
				color:black;
			}
			.alt_buttons_top{
				position:absolute; _background:white;
				top:0; width:600px; height:64px;
				border-bottom:1px solid #ccc;
			}

			.alt_buttons div{
				display:inline-block;
			}

			.alt_buttons img.reply {
			    background-image: url(||www_base||shared/img/altui_actions2.png); background-position: -0px -0px; background-repeat: no-repeat;
			}
			.alt_buttons img.trash {
			    background-image: url(||www_base||shared/img/altui_actions2.png); background-position: -42px -0px; background-repeat: no-repeat;
			}
			.alt_buttons img.archive {
			    background-image: url(||www_base||shared/img/altui_actions2.png); background-position: -84px -0px; background-repeat: no-repeat;
			}
			.alt_buttons img.flag {
			    background-image: url(||www_base||shared/img/altui_actions2.png); background-position: -126px -0px; background-repeat: no-repeat;
			}
			.alt_buttons img.move {
			    background-image: url(||www_base||shared/img/altui_actions2.png); background-position: -168px -0px; background-repeat: no-repeat;
			}
			.alt_buttons img.compose_btn {
			    background-image: url(||www_base||shared/img/altui_actions2.png); background-position: -210px -0px; background-repeat: no-repeat;
			}
			.alt_buttons img.more_btn {
			    background-image: url(||www_base||shared/img/altui_actions2.png); background-position: -252px -0px; background-repeat: no-repeat;
			}
			.alt_buttons img.spam {
			    background-image: url(||www_base||shared/img/altui_actions2.png); background-position: -294px -0px; background-repeat: no-repeat;
			}

			.alt_buttons img.reply:hover {
			    background-position: -0px -42px; cursor: pointer;
			    transform: scale(1.05);
			}
			.alt_buttons img.reply:active {
			    transform: scale(0.95);
			}

			.alt_buttons img.flag:hover {
			    background-position: -126px -42px; cursor: pointer;
			    transform: scale(1.05);
			}
			.alt_buttons img.flag:active {
			    transform: scale(0.95);
			}
			.alt_buttons img.trash:hover {
			    background-position: -42px -42px; cursor: pointer;
			    transform: scale(1.05);
			}
			.alt_buttons img.trash:active {
			    transform: scale(0.95);
			}
			.alt_buttons img.archive:hover {
			    background-position: -84px -42px; cursor: pointer;
			    transform: scale(1.05);
			}
			.alt_buttons img.archive:active {
			    transform: scale(0.95);
			}
			.alt_buttons img.move:hover {
			    background-position: -168px -42px; cursor: pointer;
			    transform: scale(1.05);
			}
			.alt_buttons img.move:active {
			    transform: scale(0.95);
			}
			.alt_buttons img.compose_btn:hover {
			    background-position: -210px -42px; cursor: pointer;
			    transform: scale(1.05);
			}
			.alt_buttons img.compose_btn:active {
			    transform: scale(0.95);
			}
			.alt_buttons img.more_btn:hover {
			    background-position: -252px -42px; cursor: pointer;
			    transform: scale(1.05);
			}
			.alt_buttons img.more_btn:active {
			    transform: scale(0.95);
			}
			.alt_buttons img.spam:hover {
			    background-position: -294px -42px; cursor: pointer;
			    transform: scale(1.05);
			}
			.alt_buttons img.spam:active {
			    transform: scale(0.95);
			}

			.alt_buttons .std_img {
			    height: 35px;
			    width: 34px;
			    left: 1px;
			    margin-right: 0px;
			}
			.alt_buttons .std_img {
			    vertical-align: middle;
			    margin-right: 2px;
			    position: relative;
			    top: 0px;
			    left: -2px;
			}
			.alt_button{
				margin-left: 15px; width: 42px; top: 0px; height: 42px;
			}

			.collapsed {
			  transform: scale(1, 0.4);
			  transform-origin: top;
			}
			.raw_links{
				right:22px;
			}
			#settings_panel {
				position:absolute;
			}
			#status_container {
				position:absolute;
				bottom:0px;
				height:30px;
				width:300px;
				background:green;
			}

			.edit_text_button{
				display:inline-block; margin:8px; padding:2px 7px;
			}

||define||edit_style||1||
||if(equal(edit_style,(1)))||
			.edit_text_button{
#				border:1px solid #0063cc;
				border-radius:3px;
				color:#0063cc;
#				background:#f2f2f2;
			}
			.edit_text_button:hover{
#				border:1px solid #007aff;
    			background:#fafafa;
#				color:#0063cc;
				color:#0059b8;
				cursor: pointer;				
			}
||endif||

||if(equal(edit_style,(2)))||
			.edit_text_button{
				border-radius:3px;
				color:#0063cc;
				background:#f2f2f2;
			}
			.edit_text_button:hover{
				background:#f8f8f8;
			}
||endif||

			.edit_image_button {
				display:inline-block; margin-left:3px; margin-right:7px;
				vertical-align: middle;
				height:26px;
				margin-top:5px;
			}
			.edit_image_button img {
#				margin-bottom:-10px;
#				margin-top:2px;
			}
			.amsg_class{
				height:44px !important;
			}


			.alt_compose_bar img{
				background: url(||www_base||shared/img/altui_ctls.png?||vz||) no-repeat;
				width:24px;
				height:24px;			
			}
			
			
			.alt_minimise img {background-position: -0px -48px;}
			.alt_minimise img:hover {background-position: -24px -48px;}
			.alt_compose_open img {background-position: -0px -144px;}
			.alt_compose_open img:hover {background-position: -24px -144px;}
			.alt_compose_big img {background-position: -0px -24px;}
			.alt_compose_big img:hover {background-position: -24px -24px;}
			.alt_compose_small img {background-position: -0px -120px;}
			.alt_compose_small img:hover {background-position: -24px -120px;}
			.alt_compose_discard img {background-position: -0px 0px;}
			.alt_compose_discard img:hover {background-position: -24px 0px;}
		
			.alt_formatting_toggle img {background-position: -0px -96px;}
			.alt_formatting_toggle img:hover {background-position: -24px -96px;}
			.alt_attach_init img {background-position: -0px -72px;}
			.alt_attach_init img:hover {background-position: -24px -72px;}
		
			.alt_slideup{
				position:absolute;
				_background:red;
				width:100%; height:100%;
				top:0px;left:0px;
			}
			.flist_link{
				display:none;
			}
			.invite_info, .spam_info, #images_disabled {
				margin-left: 3px;
			}

			.altui_burger {
			    background-image: url(||www_base||shared/img/altui_menu.png); background-position: -0px -42px; background-repeat: no-repeat;
			}
			.altui_search {
			    background-image: url(||www_base||shared/img/altui_menu.png); background-position: -42px -42px; background-repeat: no-repeat;
			}
#			.altui_search_clear{
#			    background-image: url(||www_base||shared/img/altui_menu.png); background-position: -84px -42px; background-repeat: no-repeat;
#			}
			.altui_search_clear_img{
			    background-image: url(||www_base||shared/img/altui_menu.png); background-position: -93px -51px; background-repeat: no-repeat;
			}

			.altmenu_accounts {
			    background-image: url(||www_base||shared/img/altui_menu.png); background-position: -0px -0px; background-repeat: no-repeat;
			}
			.altmenu_contacts {
			    background-image: url(||www_base||shared/img/altui_menu.png); background-position: -42px -0px; background-repeat: no-repeat;
			}
			.altmenu_calendar {
			    background-image: url(||www_base||shared/img/altui_menu.png); background-position: -84px -0px; background-repeat: no-repeat;
			}
			.altmenu_theme {
			    background-image: url(||www_base||shared/img/altui_menu.png); background-position: -126px -0px; background-repeat: no-repeat;
			}

			.alt_compose_frame{
				position:absolute; overflow-y:hidden;
			}
			.alt_formatting_toggle{
				margin-left:20px;
			}

			.alt_toolbar_wide .toolbar_whole{
				height:44px;			
			}
			.alt_toolbar_wide .toolbar_left{
				height:44px;			
				padding-top:5px;
			}
			.alt_toolbar_wide .toolbar_right{
				height:44px;			
				padding-top:14px;
			}

			.alt_toolbar_narrow .toolbar_whole, .alt_toolbar_narrow .toolbar_left, .alt_toolbar_narrow .toolbar_right{
				height:36px;			
			}

			
			
			.alt_msg_big .alt_compose_big,
			.alt_msg_small .alt_compose_small,
			.alt_msg_open .toolbar_subject, .alt_msg_open .alt_compose_open,
			.alt_msg_min .toolbar_left, .alt_msg_min .alt_minimise, .alt_msg_min .alt_minimise
			{		
				display:none;
			}

			.alt_minimise img:hover{	background-position: -24px -48px;}
			.alt_compose_open img{		background-position: -0px -144px;}
					
			.alt_slideup_now{
				transform: translate3d(0px, -800px, 0px); transition: all 500ms '+easeIn+';
				opacity:0; filter:alpha(opacity=0);
			}
			#alt_gray_overlay{
				width:100%;
				height:100%;
				position:absolute;
				top:0; left:0;
				background:black;
				_z-index:1;
				opacity:0.1; filter:alpha(opacity=10);
			}
							
			
			#accounts{
				position:absolute;
#				bottom:-8px;
			}
			
			#options_mnu{
				text-decoration:none;
			}
			#alt_buttons_links a{
				color:black;
			}
			#options_mnu:hover, #alt_buttons_links a:hover{
				text-decoration:underline !important;
			}
			.panel_inset_flushtop{
				margin-left: 0px;
			}
			
			
			#settings_panel input {
			    width: 90%;
			    padding-top: 4px: padding-bottom:4px;
			    margin-left:10px;
			}
			
			#app_menu{
				padding-bottom:7px;
			}
			
			.left_panel_header, .menu_bar, .toolbar, ._spam_info{
				background:none;
			}
			#utility_menubar{
				border-left: 1px solid #ccc;
			}
			#utility_menubar .pg_title{
				display:none;
			}
			#lpanel_calendar_alt, #lpanel_contacts_alt{
				overflow-y:auto;
			}
			#accounts .tog{
				display:none;
			}
			#sizer1 {
				display:none;
			}
			#sizer2 {
				display:none;
			}

			#gradient_banner { 
				position:absolute; top:0; left:0; height:45px; width:100%; background-image: linear-gradient(90deg,#a076b4 0%,#00afef 50%,#91ce9b 100%);
			}


			#alt_status_container{
				position:absolute;
				z-index:10;
				bottom:-3px;
				right:10%;
				left:50%;
			}
			#alt_status_container table{
				width:100%;
			}
			#alt_status_container td{
				text-align: center; 
			}
			#alt_status_container div{
#				border-radius:2px;				
				padding:10px 30px;
				display:inline-block;
			}
			#alt_status_container .success{
				background: lightgreen;
			} 
			#alt_status_container .info{
				background: #EDED91;
			} 
			#alt_status_container .warning{
				background: #EDB2BC;
			} 
			#accounts_name{
				padding-top:2px;
				font-size:0.85em;
			}
			#accounts{
				border-top:1px solid #f4f4f4;
				border-bottom:1px solid #f4f4f4;
				width:500px;
			}
			.act_panel{
				padding-top:1px;
		 		border-bottom:none;
		 		background:#ddeefb;
			}

			.cal_right_buttons{
				margin-top:8px;
			}
			.utility_show_scrollbar{
				overflow-y:auto;
			}

			#pre_menu .clean_quota{
				text-align:center;
				color:#777;
				background:none;
			}
			#pre_menu .clean_quota_full{
				color:red;
			}

		||css_end()||' + extra_msg_padding());

#		// Setup behaviour using EVENTS
//		el = dge('alt_ui_settings');
//		el.onclick = function(e){
//			alt_resize_menu(1);
//		}
//		el = dge("alt_ui_search_box");
//		el.onclick=function(e){
//			dge('alt_ui_search').focus();
//			alt_resize_menu(2);
//			stopBubble(e);
//		}
		el = dge("alt_ui_search");
		el.onchange=function(e){
#			alert('changed');
		}
		el.onkeyup=function(e){
			stopBubble(e);
		}
		el.onkeydown=function(e){
			search_resize(dge("alt_ui_search"));
			setTimeout(function(){
				update_hint(dge('alt_ui_search'),dge('alt_ui_search_hint'));
			},0);
			stopBubble(e);
		}
		el.onkeyup=function(e){
			search_keyup(e);
			stopBubble(e);
		}
		el = dge("alt_ui_settings");
		el.onclick = function(e){	// alt_ui_plain_resize
||if_set(newlook_ui)||
			if(sw.global_newlook_searchactive){
				newlook_search_reset();
				return;
			}
||endif||
			
			sw.global_newlook_collapsed = !sw.global_newlook_collapsed;
			update_folder_state(true);
#			sw.xxx_dbg = true;
#			if(!sw.global_newlook_collapsed){
#				alt_ui_plain_resize();
#			}
#			sw.xxx_dbg = false;
		}
		sw.btns_toggle = 1;
		if(!pref.newcal){
			class_add(dge('app_calendar'),'hidden');
		}
	}

	function update_folder_state(animated)
	{
		animated = true;

#		// toggle_folder
		var btn = dge("alt_ui_settings");
		var msglist = {};
		msglist.inner_el=dge('messages_list');
		var search = dge('alt_ui_search_box');
		var main_pane = dge('message_preview').parentNode;
		var accounts_el = dge('accounts');

		var settings=dge('app_menu');
		msglist.outer_el=msglist_to_outer(msglist.inner_el);
		if(msglist.outer_el.offsetLeft>0 && msglist.outer_el.old_left==U){
			msglist.outer_el.old_left = msglist.outer_el.offsetLeft;
			msglist.outer_el.old_width = msglist.outer_el.offsetWidth;
		}
		if(animated){
			class_add(msglist.outer_el,'animated_resize');
			class_add(msglist.inner_el.parentNode,'animated_resize');
			class_add(msglist.inner_el,'animated_resize');
			class_add(settings,'animated_resize');
			class_add(search,'animated_resize');
			class_add(main_pane,'animated_resize');
		}

		var folders_collapsed = sw.global_newlook_collapsed || sw.global_newlook_searchactive;
		var msglist_width;
		if(folders_collapsed){
#			// Collapse the folder list			
			msglist_width = msglist.outer_el.old_left + msglist.outer_el.old_width;
			msg_list_position(msglist, 0, msglist_width);
			msglist.state = 'collapsing';
			class_remove(search,'search_aligned');
			//main_pane.style.left=px(500-150);
		}else{
#			// Show the folder list
			msglist_width = msglist.outer_el.old_width;
			msg_list_position(msglist, msglist.outer_el.old_left, msglist_width);
			msglist.state = 'opening';
#			class_add(btn,'faded_color');
#			class_remove(btn,'loud_color');
			class_add(search,'search_aligned');				
			if(idents()>1) {
				class_remove(accounts_el,'hidden');
			}
			//main_pane.style.left=px(500);
		}
		set_w(dge('alt_ui_search_box'), folders_collapsed?msglist_width:msglist_width-60);

		if(sw.global_newlook_searchactive){
			class_add(accounts_el,'hidden');
		}
		clearTimeout(msglist.inner_el.timer);
		msglist.inner_el.timer = setTimeout(function(){
			if(msglist.state == 'collapsing'){
				class_add(btn,'loud_color');
				class_remove(btn,'faded_color');
				class_add(accounts_el,'hidden');
			}

			kill_animated_resize();
		}, animated?320:0);
	}

	// resize details
	function msg_list_position(msglist,left,width)
	{
		msglist.outer_el.style.left = px_unsafe(left);
		set_w(msglist.outer_el, width);
		set_w(msglist.inner_el, width/*-17*/);		
		set_w(msglist.inner_el.parentNode, width+17);	// left>0 x2??
		
# from static:
#		var msglist_w = pos.col3_left-pos.col2_left /*+pos.scrolbar_sz-17*/;
#		set_lw(msglist.outer_el, 200, msglist_w,true);
#		set_w(msglist.inner_el, msglist_w, true);
#		set_w(msglist.inner_el.parentNode, msglist_w, false);		// QQSCROLL		
	}

	var util_count=2;

	function populate_message()
	{
		show_overlay();

#		var el = dge('alt_overlay_pane');
#		if(el) return;

		var util_id = 'utility_alt'+(util_count++);

		var html='||html_begin()||\
#			<div id="alt_overlay_pane" class="alt_compose_frame hidden">
			  <div class="alt_compose_bar cdo_titlebar toolbar_whole" style="background:#eee;" onclick="newlook_cdo_click(event)">
				<div class="toolbar_left cdo_none" style="position:absolute;top:0;left:0;">
				 	<div class="cdo_send_only edit_text_button">Send</div>
				 	<div class="cdo_send_move edit_text_button">$$st_cmd_senddone$$</div>
				 	<div class="cdo_save_draft edit_text_button">Save Draft</div>
#				    <img src="||www_base||shared/img/1pixel.gif" class="cdo_send_encrypt lock ||if(istrue(encrypt_hide))||hidden||endif||" onclick="toggle_encrypt_menubar(this);">
					<div class="edit_image_button alt_formatting_toggle cdo_formatting_toggle"><img src="||www_base||shared/img/1pixel.gif"></div>
					<div class="edit_image_button alt_attach_init cdo_attach_init"><img src="||www_base||shared/img/1pixel.gif"></div>
#				 	<div class="cdo_dbg_move edit_text_button">[move]</div>
				</div>
				<div class="toolbar_subject" style="position:absolute;top:0;left:0;width:155px; white-space:nowrap; overflow:hidden; text-overflow: ellipsis; font-size:18px;padding-left:5px; padding-top:7px;">Subject text ...</div>
			 	<div class="toolbar_right cdo_none" style="position:absolute;top:0;right:0;">
					<div class="edit_image_button alt_minimise cdo_edit_minimise"><img src="||www_base||shared/img/1pixel.gif" title="$$st_cmd_compose_min_tt$$"></div>
					<div class="edit_image_button alt_compose_open cdo_edit_open"><img src="||www_base||shared/img/1pixel.gif" title="$$st_cmd_compose_open_tt$$"></div>
					<div class="edit_image_button alt_compose_small cdo_compose_small"><img src="||www_base||shared/img/1pixel.gif" title="$$st_cmd_compose_small_tt$$"></div>
					<div class="edit_image_button alt_compose_big cdo_compose_big"><img src="||www_base||shared/img/1pixel.gif" title="$$st_cmd_compose_big_tt$$"></div>
					<div class="edit_image_button alt_compose_discard cdo_edit_discard"><img src="||www_base||shared/img/1pixel.gif" title="$$st_cmd_compose_close_tt$$"></div>
				</div>
			 </div>
			 <div id="'+util_id+'" style="background-color:pink; width:100%; height:664"></div>
#			</div>
			||html_end()||';

		var el = new_anchor('div', html, dge('alt_ui'));
		el.id = 'alt_overlay_pane';
		class_set(el,'alt_compose_frame alt_msg_small');
		el.style.right = px(0);

		sw.util2 = dge(util_id);

		util_count++;

		compose_update_sizing(el);
//		do_resize();
	}
	function kill_animated_resize()
	{
		var els = document.getElementsByClassName('animated_resize');
		for(var i=0;i<els.length;i++){
			class_remove(els[i],'animated_resize')
		}		
	}

	// fundamentally layout the panels
	function alt_ui_plain_resize()	
	{
		kill_animated_resize();

		var pos = {
			screen_w: ClientWidth(),
			screen_h: ClientHeight(),
			col1_left:0,
			col1_width:200,
			col2_left:msglist_to_outer(dge('messages_list')).offsetLeft,
			col3_left:dge('message_preview').parentNode.offsetLeft,
			search_height: 44+1/*+22*/,
			menu_height: 44+44+2,
			acct_height: 45,
			scrolbar_sz: 17  		//get_scrollbar_width();
		};		

		if(idents()<=1){
			pos.acct_height=0;
		}

		if(sw.cur_app_menu_type=='calendar'){
			pos.search_height += 0;
		}else if(sw.cur_app_menu_type=='contacts'){
			pos.search_height += 20;
		}
		pos.bar_height = pos.search_height;

#		//// Search boxes etc sizing
		var lst_el = dge('search_etc');
		var srch_extra_el = dge('alt_ui_search_param');
		var srch_input_el = dge("alt_ui_search")
		
		set_hw_both(lst_el,pos.search_height,pos.col3_left,false);
		set_w(srch_input_el, pos.col3_left-120);
		set_t(srch_extra_el, pos.search_height);

		var msglist_top = pos.search_height;
		if(defined(sw.global_newlook_searchactive)){
#			pos.search_height = 90;
			pos.search_height += 44;
			class_remove(srch_extra_el,"hidden");
			
			dge('alt_ui_search_inbox').style.background = sw.search_location=='single'?'white':'#eee';		
			dge('alt_ui_search_recent').style.background =  sw.search_location=='recent'?'white':'#eee';
			dge('alt_ui_search_all').style.background =  sw.search_location=='all'?'white':'#eee';			
		}else{
			class_add(srch_extra_el,"hidden");
		}

#		//// Menu and accounts panels		
		var mnu_el=dge('app_menu');
		var accts_el=dge('accounts');

		set_w(mnu_el, pos.col1_width, false);
#		class_add(mnu_el, 'hidden');
#		set_hw(accts_el, pos.menu_height, pos.col2_left, false);
		set_t(accts_el, pos.search_height);
		//set_t(settings_el, fldlist_realh-44);
		pos.menu_height = mnu_el.offsetHeight;



#		//// Setup menubar height
		set_h(dge('search_etc'), pos.bar_height);
		set_h(dge('alt_ui_settings'), pos.bar_height);
		set_h(dge('alt_ui_search_box'), pos.bar_height);
		set_t(dge('alt_ui_separator'), pos.bar_height-1);
		set_h(dge('alt_buttons_top'), pos.bar_height-1);

		
#		set_hw(dge('utility_menubar'), pos.bar_height-11,pos.screen_w-pos.col1_width);
		set_hw(dge('utility_menubar'), pos.bar_height-11);
		set_t(dge('utility_alt'), pos.bar_height);		
		set_h(dge('lpanel_hdr_alt'), pos.bar_height-8);
		set_th(dge('lpanel_contacts_alt'), pos.bar_height, pos.screen_h-pos.bar_height-pos.menu_height);
		set_th(dge('lpanel_calendar_alt'), pos.bar_height, pos.screen_h-pos.bar_height-pos.menu_height);
		


#		//// Folders list sizing
		var lst_el = dge('folders');
		var lst_outer_el = fldlist_to_outer(lst_el);
		
		var fldlist_h = pos.screen_h-pos.search_height-pos.menu_height-pos.acct_height;
		set_t(lst_outer_el, pos.search_height + pos.acct_height/*+45*/);
		set_hw(lst_outer_el,fldlist_h,pos.col1_width+pos.scrolbar_sz,true);
		var fldlist_realh=fldlist_h;
		if(lst_el.firstChild && lst_el.firstChild.scrollHeight>fldlist_realh){
			fldlist_realh=lst_el.firstChild.scrollHeight;
		}
		set_hw(lst_el,fldlist_realh-44*0,pos.col1_width+pos.scrolbar_sz,true);
#		set_w(lst_el.parentNode,pos.col1_width+pos.scrolbar_sz, false);	//???

#		//// Messages list
#		var lst_el = dge('messages_list');
#		var lst_outer_el = msglist_to_outer(lst_el);

		var msglist = {};
		msglist.inner_el=dge('messages_list');
		msglist.outer_el=msglist_to_outer(msglist.inner_el);

		var msglist_h1 = pos.screen_h-pos.search_height;
		var msglist_h2 = msglist.inner_el.scrollHeight-44;
		
		var msglist_top = pos.search_height;
#		if(defined(sw.global_newlook_searchactive)){
#			msglist_top = 90;
#		}		
		set_th(msglist.outer_el, msglist_top,msglist_h1);
		set_h(msglist.inner_el, msglist_h2);
		
		var msglist_w = pos.col3_left-pos.col2_left /*+pos.scrolbar_sz-17*/;
		var collapsed = sw.global_newlook_collapsed || sw.global_newlook_searchactive;
		msg_list_position(msglist,  collapsed?0:200, msglist_w);
	
# 		//// Message "preview" sizing
		var msg_el = dge('message_preview');
		var bts_el = dge('alt_buttons_top');
		var msg_outer_el = msg_el.parentNode;

# 		:-( remove prescroll infrastructure
#		msg_el.style.paddingTop = px(pos.bar_height);

		var w_c3 = pos.screen_w-pos.col3_left;
		var msg_h = pos.screen_h-45;
		set_t(msg_outer_el,45);
		set_hlw(msg_outer_el,msg_h,500,pos.screen_w);
		set_hlw(bts_el, pos.bar_height-1, 500, pos.screen_w);
		set_hlw(msg_el, pos.screen_h-44, 0, w_c3+pos.scrolbar_sz);

#		//// Layout message switching tabs
		layout_compose_tabs(pos.screen_h,pos.col2_left, w_c3, pos.col3_left);
		
		
#		#altui_search_clear
	}


	function layout_compose_tabs(h,w1, w,left3)
	{
		var switcher = dge('switcher');
		var count = 0, edge_gap=30, right_edge=edge_gap;
		var msg_open = false;
		for(var i=1; i<switcher.childNodes.length; i++){
			var switch_tab = switcher.childNodes[i];
			count++;

			var panel = panel_correct(switch_tab,'inner').node_ref;
			if(panel==U) continue;


			var frame = alt_dom2frame(panel);
			
			class_remove(frame,'hidden');
			
#			frame.size='max'; // 'small'  'min'			
			if(frame.collapsed){
				frame.style.top = 'auto';
				frame.style.left = 'auto';
				frame.style.bottom = 0;
				frame.style.right = px(right_edge);
				frame.style.height = px(36);
				frame.style.width = px(260);
				right_edge += 300;
				
			} else if(frame.size=='big'){
				frame.style.bottom = 'auto';
				frame.style.right = 'auto';
				frame.style.top = 0;
				frame.style.left = px(left3);
				frame.style.height = px(h);
				frame.style.width = px(w);
				msg_open = true;

			} else /*if(frame.size=='small')*/{
				frame.style.top = px(edge_gap);
				frame.style.left = px(w1+edge_gap);
				frame.style.bottom = px(edge_gap/3);
				frame.style.right = px(edge_gap);
				frame.style.height = 'auto';
				frame.style.width = 'auto';
				msg_open = true;
			}
			
			var o=sw.active;
			if (!class_contains(o,'compose')) continue;

			var xx={};
			xx['pane_h']=h; //frame.offsetHeight;
			xx['menu_h']=frame.firstChild.offsetHeight;
			xx['chdr_h']=o.compose_header.offsetHeight;
			var ef = o.field_xeframe.firstChild;
			if(pref.editor_textonly){
#				ef.style[htype]=px(xx['cc_h']-(xx['mnu_h']+xx['chdr_h']) - panel_gap - 4 - 24);
#				ef.style['width']=px(xx['cc_w'] - panel_gap - 4 - 24);
			}else{
				var hh = xx['pane_h']-xx['chdr_h']-xx['menu_h']-(frame.size=='max'?8:8);
				ef.style['height']=px(hh-37);	// bad magic number
			}
		}

		if(msg_open){
			show_overlay();
		}else{
			hide_overlay();
		}


	}
	function plain_config()
	{
		return 'No extra settings';
	}
	function msglist_to_outer(el)
	{
		return el.parentNode.parentNode;
	}
	function fldlist_to_outer(el)
	{
		return el.parentNode.parentNode;
	}

	function toggle_buttons()
	{
		if(!sw.btns_toggle) sw.btns_toggle=0;
		sw.btns_toggle = (sw.btns_toggle+1)%3;
		var btns1 = dge('alt_buttons_top');
		var btns2 = dge('alt_buttons_bottom');
		class_remove(btns1,'hidden');
		class_remove(btns2,'hidden');
		if(sw.btns_toggle==1){
			class_add(btns1,'hidden');
		} else if(sw.btns_toggle==2){
			class_add(btns1,'hidden');
			class_add(btns2,'hidden');
		} else {
		}
		scroll_msg();
	}

	newlook_register('modern1', 'modern1', obj, {alt:true});
	window.plain_look = obj;

#	document.body.ontouchmove = function(e){
#		preventDefault(e);
#	};

	function search_resize(el)
	{
		var len = el.value.length;
		if(len<17) {
			el.style.fontSize = '180%';
		} else if (len<27) {
			el.style.fontSize = '160%';
		} else {
			el.style.fontSize = '135%';
		}
	}

	function msglist_unsearch()
	{
		var el = dge("alt_ui_search");
		el.value='';
		search_resize(el);
		
		sw.global_newlook_searchactive = U;
		update_folder_state(false);
		do_resize();
	}

	function central_css(src,cs)
	{
		var col = cs.one_color;
		var loud_col, faded_col, cursor_col;

		var default_loud_col = rgb2hsl(rgb_init(0xdd,0xee,0xfb));
#			rgb: #ddeefb
#			hsl: [0.5722222222222222, 0.7894736842105262, 0.9254901960784314, 1]

		if(src=='default'){
			loud_col = default_loud_col;
			faded_col = rgb2hsl(rgb_init(0xf9,0xf9,0xf9));
			cursor_col = rgb2hsl(rgb_init(0xd6,0xe4,0xe9));
		}else if(src=='anycolor'){
			loud_col= hsl_max_l(hsl_modulate(col,0,+0.5,+0.9),0.8);
			loud_col[hsl_s]=default_loud_col[hsl_s]+(col[hsl_s]-default_loud_col[hsl_s])*0.2;
			loud_col[hsl_l]=default_loud_col[hsl_l]+(col[hsl_l]-default_loud_col[hsl_l])*0.05;
			
			loud_col = col;

			faded_col= hsl_modulate(col,0,-0.2,+0.97);					// #f9f9f9
			cursor_col = hsl_modulate(loud_col,0,-0.2,-0.07);
		}else{
			return'';
		}
		var txt = '';
		txt += '.fldlist_color { background-color:'+hsl_out(loud_col)+';}';	// QQPP
		txt += '.faded_color { background-color:'+hsl_out(faded_col)+' !important;}';
#		txt += '.loud_color { background-color:'+hsl_out(loud_col)+' !important;}';

		txt += '#folders .part_cursor:hover, #folders .part_cursor a:hover {background:'+hsl_out(cursor_col)+'}';
		txt += '.ftree .selected{background:'+hsl_out(cursor_col)+';}';

		return txt;
	}
})();
# NO CODE BELOW HERE

function do_close()
{
#	var el = dge('alt_overlay_pane');
#	class_add(el,'hidden');
#	windows_manager_tabsformat();

//	"alt_overlay_pane"
//	window_manager_killpane(sw.active);
}

function hide_overlay()
{
	class_add(dge("alt_gray_overlay"), "hidden");
}
function show_overlay()
{
	class_remove(dge("alt_gray_overlay"), "hidden");
}


function newlook_cdo_click(e)
{
	var t = target(e);
	if(!class_contains(t,'cdo_')) t = t.parentNode;
	var frame = alt_dom2frame(t); 
	var node = frame.compose_panel;
	set_sw_active(node);
	
	if(class_contains(t,'cdo_edit_discard')){ 			edit_discard();hide_overlay();
	} else if(class_contains(t,'cdo_send_only')){		do_send(); hide_overlay();
	} else if(class_contains(t,'cdo_send_move')){		do_send_move(e);hide_overlay();
	} else if(class_contains(t,'cdo_save_draft')){ 		do_save_draft();

	} else if(class_contains(t,'cdo_formatting_toggle')){do_formatting_toggle();
	} else if(class_contains(t,'cdo_attach_init')){		do_attach_init(true);
	} else if(class_contains(t,'cdo_dbg_move')){ 		dbg_msg_move(frame);

	} else if(class_contains(t,'cdo_edit_minimise')){ 	edit_minimise(frame);
	} else if(class_contains(t,'cdo_edit_open')){ 	  	edit_minimise(frame);
	} else if(class_contains(t,'cdo_compose_big'))	{ 	do_size_toggle(frame);
	} else if(class_contains(t,'cdo_compose_small')){ 	do_size_toggle(frame);
	} else if(class_contains(t,'cdo_close')){			do_close();hide_overlay();
	
	} else if(class_contains(t,'cdo_titlebar') && frame.allow_drag==U){
		if(frame.collapsed){
			edit_minimise(frame);
		}else{
			popout_edit();		
		}
#														edit_minimise(frame);
#														do_size_toggle(frame);
	}
}

function do_formatting_toggle()
{
	var el = dge('editor_bar'+sw.active.instance);
	class_toggle(el,'hidden');
	message_resize();
}

function do_size_toggle(frame)
{
	var e=event;
	if(true){
		popout_edit();
	}else{
		frame.size='small';
		frame.collapsed = false;
		class_add(frame,'hidden');
		compose_update_sizing(frame);
	}
}

function dbg_msg_move(frame)
{
	frame.allow_drag = true;
	Drag.init(frame,frame); 
	alert('DEBUG FEATURE message in now draggable by titlebar');
}

function compose_update_sizing(frame)
{
	var wide = (frame.size=='big' && !frame.collapsed);
	class_ra(frame,['alt_toolbar_wide','alt_toolbar_narrow'], (wide?'alt_toolbar_wide':'alt_toolbar_narrow'));		

	var wanted_state = (frame.size=='big') ? 'alt_msg_big' : 'alt_msg_small';
	class_ra(frame,['alt_msg_big','alt_msg_small'], wanted_state);

	var wanted_state = (frame.collapsed) ? 'alt_msg_min' : 'alt_msg_open';
	class_ra(frame,['alt_msg_min','alt_msg_open'], wanted_state);

	do_resize();
}

function edit_minimise(frame)
{
	frame.collapsed = (frame.collapsed?false:true);
	var node = frame.compose_panel;
	var subject = node.field_subject.value;
	if(subject.length==0) subject='Message';
	frame.childNodes[0].childNodes[1].innerHTML = subject;	
	compose_update_sizing(frame);
}
function alt_dom2frame(node)
{
	return ancestor_by_class(node, 'alt_compose_frame');
}


function newlook_modern1_quota_reset()
{
	if(pref.newlook_layout!='modern1') return;
	var el = dge('pre_menu');
	if(!el) return;
	el.innerHTML = '';	
}
function newlook_modern1_quota_set()
{
	if(pref.newlook_layout!='modern1') return;
	var el = dge('pre_menu');
	if(!el) return;
	el.innerHTML = '<div class="clean_quota '+(sw.quota.pct>90?'clean_quota_full':'')+'">'+quota_info()+'</div>';	
}