# dom-region.js	region definition code (based on dom-drag.js code structure)

var Region = {

	obj : null,

	init : function(o, minX, maxX, minY, maxY)
	{
        dbg('fns Region.init');
		o.onmousedown	= Region.start;

		o.minX	= typeof minX != 'undefined' ? minX : null;
		o.minY	= typeof minY != 'undefined' ? minY : null;
		o.maxX	= typeof maxX != 'undefined' ? maxX : null;
		o.maxY	= typeof maxY != 'undefined' ? maxY : null;

		o.onDragStart	= new Function();
		o.onDragEnd		= new Function();
		o.onDrag		= new Function();
		
		o.drag_init = true;
	},

	start : function(e)
	{
        dbg('fns Region.start');
		var o = Region.obj = this;
		e = Region.fixE(e);

		var y = y_relative_to(e.clientY,o);	// parseInt(o.style.top);		+' Y='+);
		var x = x_relative_to(e.clientX,o); //parseInt(o.style.left);
		o.onDragStart(x, y);

		dbg('X='+x_relative_to(e.clientX,o)+' Y='+y_relative_to(e.clientY,o));

		o.lastX	= x;
		o.lastY	= y;

#		if (o.minX != null)	o.minMouseX	= e.clientX - x + o.minX;
#		if (o.maxX != null)	o.maxMouseX	= o.minMouseX + o.maxX - o.minX;
#		if (o.minY != null)	o.minMouseY	= e.clientY - y + o.minY;
#		if (o.maxY != null)	o.maxMouseY	= o.minMouseY + o.maxY - o.minY;
		
		o.old_onmousemove	= document.onmousemove;
		o.old_onmouseup		= document.onmouseup;

		document.onmousemove	= Region.drag;
		document.onmouseup		= Region.end;
		
		if(o.stop) stopEvent(e);
		
		return false;
	},

	drag : function(e)
	{
        dbg('fns Region.drag');
		e = Region.fixE(e);
		var o = Region.obj;
		if (!o) return;
		
		var y = y_relative_to(e.clientY,o);
		var x = x_relative_to(e.clientX,o);


#		if (o.minX != null) ex = Math.max(ex, o.minMouseX);
#		if (o.maxX != null) ex = Math.min(ex, o.maxMouseX);
#		if (o.minY != null) ey = Math.max(ey, o.minMouseY);
#		if (o.maxY != null) ey = Math.min(ey, o.maxMouseY);

		dbg("x="+x+" y="+y);

		if (false&&o.xgrid) {
			var mx = Math.floor(o.xgrid/2);
			var delta = nx%o.xgrid - mx
			ex = ex - delta;
			nx = nx - delta;
			var my = Math.floor(o.ygrid/2);
			delta = ny%o.ygrid - my
			ey = ey - delta;
			ny = ny - delta;
		}
		if (o.validate_cb) {
			var xy = o.validate_cb(o,x,y);
			x=xy[0];
			y=xy[1];
		}

		Region.obj.lastX = x;
		Region.obj.lastY = y;

		dbg("X="+x+" Y="+y);

		Region.obj.onDrag(x, y);
		return false;
	},

	end : function()
	{
        dbg('fns Region.end');
		var o = Region.obj;
		if (!o) return;
		document.onmousemove = o.old_onmousemove;
		document.onmouseup   = o.old_onmouseup;
		Region.obj.onDragEnd(o.lastX, o.lastY);
		Region.obj = null;
	},

	fixE : function(e)
	{
        dbg('fns Region.fixE');
		if (typeof e == 'undefined') e = window.event;
		if (typeof e.layerX == 'undefined') e.layerX = e.offsetX;
		if (typeof e.layerY == 'undefined') e.layerY = e.offsetY;
		return e;
	},
	grid : function(o,x,y)
	{
		o.xgrid = x;
		o.ygrid = y;
	},
	validate : function(o,cb,stop)
	{
		o.validate_cb = cb;
		if(stop) o.stop = stop;
	},
	cb : function(o,cb1,cb2,cb3)
	{
		if(cb1) o.onDragStart=cb1;	
		if(cb2) o.onDrag=cb2;
		if(cb3) o.onDragEnd=cb3;
	}
	
	
};
